/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.Config;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.PastureBreedingData;
import ludichat.cobbreeding.PastureInventory;
import ludichat.cobbreeding.PastureUtilities;
import ludichat.cobbreeding.PokemonEgg;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PokemonPastureBlockEntityMixin
implements PastureInventory,
class_1278 {
    @Unique
    private static final Logger LOGGER = Cobbreeding.LOGGER;
    @Unique
    private static final class_2746 HAS_EGG = CustomProperties.HAS_EGG;

    @Override
    public class_2371<class_1799> getItems() {
        PastureBreedingData data;
        int hash = this.hashCode();
        if (PastureBreedingData.registry.containsKey(hash)) {
            data = PastureBreedingData.registry.get(hash);
        } else {
            data = new PastureBreedingData(PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks(), (class_2371<class_1799>)class_2371.method_10213((int)1, (Object)class_1799.field_8037));
            PastureBreedingData.registry.put(hash, data);
        }
        return data.getEgg();
    }

    @Unique
    private static Config getConfig() {
        return Cobbreeding.INSTANCE.getConfig();
    }

    @Inject(at={@At(value="HEAD")}, method={"TICKER$lambda$11"})
    private static void init(class_1937 world, class_2338 pos, class_2680 state, PokemonPastureBlockEntity blockEntity, CallbackInfo ci) {
        PastureBreedingData data;
        if (world.field_9236) {
            return;
        }
        int hash = blockEntity.hashCode();
        if (PastureBreedingData.registry.containsKey(hash)) {
            data = PastureBreedingData.registry.get(hash);
        } else {
            data = new PastureBreedingData(PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks(), (class_2371<class_1799>)class_2371.method_10213((int)1, (Object)class_1799.field_8037));
            PastureBreedingData.registry.put(hash, data);
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_EGG, (Comparable)Boolean.valueOf(!((class_1799)data.getEgg().get(0)).method_7960())));
        int time = data.getTime();
        if (--time <= 0) {
            PokemonEgg.Info eggData;
            time = PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks();
            List tetheredPokemon = blockEntity.getTetheredPokemon();
            List<Pokemon> pokemon = PastureUtilities.getPokemon(tetheredPokemon);
            PastureUtilities.applyMirrorHerb(pokemon);
            double randomNumber = Math.random();
            double eggChance = PokemonPastureBlockEntityMixin.getConfig().getEggCheckChance();
            LOGGER.trace("Trying egg, roll: %b (%f >= 1 - %f)".formatted(randomNumber >= (double)(1.0f - PokemonPastureBlockEntityMixin.getConfig().getEggCheckChance()), randomNumber, eggChance));
            if (((class_1799)data.getEgg().get(0)).method_7960() && randomNumber >= 1.0 - eggChance && (eggData = PastureUtilities.chooseEgg(pokemon)) != null && eggData.component1() != null) {
                class_1799 eggItem = new class_1799((class_1935)Cobbreeding.EGG_ITEM.get());
                eggData.toNbt(eggItem.method_7948());
                eggItem.method_7948().method_10569("timer", class_3532.method_15375((float)((float)(eggData.component1().getEggCycles() * 600) * PokemonPastureBlockEntityMixin.getConfig().getEggHatchMultiplier())));
                data.getEgg().set(0, (Object)eggItem);
            }
        }
        data.setTime(time);
    }

    @Inject(at={@At(value="HEAD")}, method={"writeNbt"})
    private void writeNbt(class_2487 nbt, CallbackInfo ci) {
        class_1262.method_5426((class_2487)nbt, this.getItems());
    }

    @Inject(at={@At(value="TAIL")}, method={"readNbt"})
    private void readNbt(class_2487 nbt, CallbackInfo ci) {
        class_1262.method_5429((class_2487)nbt, this.getItems());
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        return true;
    }

    public int[] method_5494(class_2350 direction) {
        return new int[]{0};
    }
}

