/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.HeartstoneClient;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.DataObjectReference;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_22;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7706;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Heartstone {
    public static final String MOD_ID = "heartstone";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean CURIO = PlatHelper.isModLoaded((String)"curio");
    public static final boolean TRINKETS = PlatHelper.isModLoaded((String)"trinkets");
    public static final Supplier<Integer> HIGHLIGHT_COLOR;
    public static final Supplier<Boolean> HIGHLIGHT;
    public static final Supplier<Integer> HIGHLIGHT_DISTANCE;
    public static final Supplier<Integer> HIGHLIGHT_DURATION;
    public static final DataObjectReference<MapDecorationType<?, ?>> HEARTSTONE_MARKER;
    public static final Supplier<class_3414> HEARTSTONE_SOUND;
    public static final Supplier<class_2400> HEARTSTONE_PARTICLE;
    public static final Supplier<class_2400> HEARTSTONE_PARTICLE_EMITTER;
    public static final Supplier<class_1792> HEARTSTONE_ITEM;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void commonInit() {
        PlatHelper.addCommonSetup(Heartstone::commonSetup);
        if (PlatHelper.getPhysicalSide().isClient()) {
            HeartstoneClient.init();
        }
        RegHelper.addItemsToTabsRegistration(Heartstone::addItemsToTabs);
        MapDataRegistry.addDynamicServerMarkersEvent(Heartstone::getDynamicDecorations);
        MoonlightEventsHelper.addListener(Heartstone::onPlayerDeath, IDropItemOnDeathEvent.class);
    }

    private static Set<MapBlockMarker<?>> getDynamicDecorations(class_1657 player, int mapId, class_22 data) {
        List<class_1799> list = HeartstoneItem.getAllHeartstones(player);
        ArrayList<class_1657> visiblePlayers = new ArrayList<class_1657>();
        Iterator iterator = new ArrayList(player.method_37908().method_8503().method_3760().method_14571()).iterator();
        for (class_1799 i : list) {
            boolean found = false;
            while (iterator.hasNext() && !found) {
                class_1657 targetPlayer = (class_1657)iterator.next();
                HeartstoneItem cfr_ignored_0 = (HeartstoneItem)i.method_7909();
                if (!HeartstoneItem.arePlayersBound(player, i, targetPlayer, true)) continue;
                visiblePlayers.add(targetPlayer);
                iterator.remove();
                found = true;
            }
        }
        HashSet markers = new HashSet();
        for (class_1657 p : visiblePlayers) {
            MapBlockMarker marker = ((MapDecorationType)HEARTSTONE_MARKER.get()).createEmptyMarker();
            marker.setPos(p.method_23312());
            marker.setRotation((int)p.method_36454());
            marker.setName(p.method_5476());
            markers.add(marker);
        }
        return markers;
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addBefore(class_7706.field_41060, i -> i.method_31574(class_1802.field_8251), new class_1935[]{(class_1935)HEARTSTONE_ITEM.get()});
    }

    public static void commonSetup() {
        NetworkHandler.registerMessages();
    }

    public static void onPlayerDeath(IDropItemOnDeathEvent event) {
        class_1657 p = event.getPlayer();
        if (event.isBeforeDrop()) {
            List<class_1799> list = HeartstoneItem.getAllHeartstones(p);
            for (class_1799 h : list) {
                class_1657 target = HeartstoneItem.getBoundPlayer(p, h, false);
                if (target == null) continue;
                Long id = HeartstoneItem.getHeartstoneId(h);
                List<class_1799> targetList = HeartstoneItem.getAllHeartstones(target);
                for (class_1799 th : targetList) {
                    if (!HeartstoneItem.hasMatchingId(id, th)) continue;
                    HeartstoneItem.crack(th, (class_1297)target);
                }
            }
        }
    }

    static {
        ConfigBuilder config = ConfigBuilder.create((class_2960)Heartstone.res("client"), (ConfigType)ConfigType.CLIENT);
        config.push("highlight");
        HIGHLIGHT_COLOR = config.comment("Highlight color").defineColor("color", 16738511);
        HIGHLIGHT = config.define("enabled", true);
        HIGHLIGHT_DISTANCE = config.comment("Distance at which the player highlight will take effect").define("distance", 20, 0, 10000);
        HIGHLIGHT_DURATION = config.define("duration", 100, 0, 10000);
        config.pop();
        config.buildAndRegister();
        HEARTSTONE_MARKER = new DataObjectReference(Heartstone.res(MOD_ID), MapDataInternal.KEY);
        HEARTSTONE_SOUND = RegHelper.registerSound((class_2960)Heartstone.res("item.heartstone"));
        HEARTSTONE_PARTICLE = RegHelper.registerParticle((class_2960)Heartstone.res("heartstone_trail"));
        HEARTSTONE_PARTICLE_EMITTER = RegHelper.registerParticle((class_2960)Heartstone.res("heartstone_emitter"));
        HEARTSTONE_ITEM = RegHelper.registerItem((class_2960)Heartstone.res(MOD_ID), HeartstoneItem::new);
    }
}

