/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.mixins;

import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.mixins.SpawningConditionMixin;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.items.ItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.KeyItemConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomKeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomSecondaryItemCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SingleEntitySpawnAction.class})
public abstract class SingleEntitySpawnActionMixin {
    @Unique
    ModConfigs MythsAndLegends$config = MythsAndLegends.getConfigManager().getConfig();
    @Unique
    SpawningContext MythsAndLegends$ctx;
    @Unique
    SpawnDetail MythsAndLegends$detail;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(SpawningContext ctx, SpawnDetail detail, CallbackInfo ci) {
        this.MythsAndLegends$ctx = ctx;
        this.MythsAndLegends$detail = detail;
    }

    @Inject(method={"run"}, at={@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;getWorld()Lnet/minecraft/server/world/ServerWorld;", ordinal=0, shift=At.Shift.AFTER)})
    private void afterSpawnEntity(CallbackInfoReturnable<EntitySpawnResult> cir) {
        SpawningContext ctx = ((SingleEntitySpawnAction)this).getCtx();
        SpawnDetail detail = ((SingleEntitySpawnAction)this).getDetail();
        this.MythsAndLegends$processSpawnAction(ctx, detail);
    }

    @Unique
    private void MythsAndLegends$processSpawnAction(SpawningContext ctx, SpawnDetail detail) {
        Spawner spawner = ctx.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            class_3222 player = MythsAndLegendsConditions.getPlayerFromUUID(ctx.getWorld(), playerSpawner.getUuid());
            for (SpawningCondition condition : detail.getConditions()) {
                if (!(condition instanceof SpawningConditionMixin)) continue;
                SpawningConditionMixin conditionMixin = (SpawningConditionMixin)condition;
                List<AppendageCondition> appendages = conditionMixin.getAppendages();
                this.MythsAndLegends$filterAppendageConditions(appendages, player);
            }
        }
    }

    @Unique
    private void MythsAndLegends$filterAppendageConditions(List<AppendageCondition> appendages, class_3222 player) {
        boolean itemConditionMet = false;
        for (AppendageCondition appendage : appendages) {
            CustomSecondaryItemCondition customSecondaryItemCondition;
            if (appendage instanceof ItemCondition) {
                ItemCondition itemCondition = (ItemCondition)appendage;
                if (itemCondition.getItemConditionIdentifier() == null) continue;
                itemConditionMet = true;
                continue;
            }
            if (!(appendage instanceof CustomSecondaryItemCondition) || (customSecondaryItemCondition = (CustomSecondaryItemCondition)appendage).getItemConditionIdentifier() == null) continue;
            itemConditionMet = true;
        }
        this.MythsAndLegends$processConditions(appendages, player, itemConditionMet);
    }

    @Unique
    private void MythsAndLegends$processConditions(List<AppendageCondition> appendages, class_3222 player, boolean itemConditionMet) {
        boolean configConsume = this.MythsAndLegends$config.consume_items_on_successful_spawn;
        boolean consumeOnlyItems = this.MythsAndLegends$config.ignore_key_items;
        for (AppendageCondition appendage : appendages) {
            if (appendage instanceof CustomKeyItemCondition) {
                CustomKeyItemCondition customKeyItemCondition = (CustomKeyItemCondition)appendage;
                List<CustomKeyItemCondition.CustomConditionItem> customItems = customKeyItemCondition.getItemConditions();
                if (customItems == null || customItems.isEmpty()) continue;
                for (CustomKeyItemCondition.CustomConditionItem item : customItems) {
                    if (item == null || !configConsume && !item.consume || consumeOnlyItems && itemConditionMet && !item.consume) continue;
                    this.MythsAndLegends$removeCustomItemFromPlayer(player, item.id, item.count);
                }
                continue;
            }
            if (appendage instanceof CustomSecondaryItemCondition) {
                CustomSecondaryItemCondition customStoneCondition = (CustomSecondaryItemCondition)appendage;
                CustomKeyItemCondition.CustomConditionItem item = customStoneCondition.getItemConditionIdentifier();
                if (item == null || !configConsume && !item.consume) continue;
                this.MythsAndLegends$removeCustomItemFromPlayer(player, item.id, item.count);
                continue;
            }
            if (appendage instanceof KeyItemConditions.KeyItem) {
                KeyItemConditions.KeyItem keyItem = (KeyItemConditions.KeyItem)appendage;
                if (!configConsume || keyItem.getItemCondtionIdentifier() == null || itemConditionMet && this.MythsAndLegends$config.ignore_key_items) continue;
                this.MythsAndLegends$removeKeyItemFromPlayer(player, keyItem.getItemCondtionIdentifier().method_12832());
                continue;
            }
            if (!(appendage instanceof ItemCondition)) continue;
            ItemCondition itemCondition = (ItemCondition)appendage;
            if (!configConsume || itemCondition.getItemConditionIdentifier() == null) continue;
            this.MythsAndLegends$removeItemFromPlayer(player, itemCondition.getItemConditionIdentifier(), itemCondition.getItemNamespace(), itemCondition.getItemPath());
        }
    }

    @Unique
    private void MythsAndLegends$removeItemFromPlayer(class_3222 player, class_2960 ItemConditionIdentifier, String itemNamespace, String itemPath) {
        int requiredCount;
        if (ItemConditionIdentifier == null) {
            return;
        }
        class_2960 ItemIdentifier = new class_2960(itemNamespace, itemPath);
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(class_7924.field_41197);
        class_1792 item = Objects.requireNonNull((class_1792)items.get(ItemIdentifier)).method_8389();
        if (!InventoryUtils.removeItemFromInventory(player, item, requiredCount = MythsAndLegendsConditions.parseRequiredCount(ItemConditionIdentifier.method_12832()), this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.method_5667(), ItemIdentifier, requiredCount);
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
    }

    @Unique
    private void MythsAndLegends$removeCustomItemFromPlayer(class_3222 player, class_2960 customItemId, int count) {
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(class_7924.field_41197);
        class_1792 customItem = Objects.requireNonNull((class_1792)items.get(customItemId)).method_8389();
        if (!InventoryUtils.removeItemFromInventory(player, customItem, count, this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.method_5667(), customItemId, count);
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
    }

    @Unique
    private void MythsAndLegends$removeKeyItemFromPlayer(class_3222 player, String keyItemPath) {
        class_2960 keyItemId = new class_2960("myths_and_legends", keyItemPath);
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(class_7924.field_41197);
        class_1792 keyItem = Objects.requireNonNull((class_1792)items.get(keyItemId)).method_8389();
        if (!InventoryUtils.removeItemFromInventory(player, keyItem, 1, this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.method_5667(), keyItemId, 1);
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
    }
}

