/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.events.PlayerEvents;
import com.github.d0ctorleon.mythsandlegends.utils.FormAndAspectUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import dev.architectury.event.events.common.TickEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TickEvents {
    private static final Random random = new Random();
    private static int nextInventoryCheckTick = 0;

    public TickEvents() {
        TickEvent.SERVER_PRE.register(this::onServerPreTick);
        TickEvent.SERVER_POST.register(this::onServerPostTick);
        TickEvent.SERVER_LEVEL_PRE.register(this::onServerLevelPreTick);
        TickEvent.SERVER_LEVEL_POST.register(this::onServerLevelPostTick);
        TickEvent.PLAYER_PRE.register(this::onPlayerPreTick);
        TickEvent.PLAYER_POST.register(this::onPlayerPostTick);
        MythsAndLegends.LOGGER.info("Tick Events Registered");
    }

    public void onServerLevelPreTick(class_3218 level) {
        if (level.method_8510() % 200L == 0L) {
            // empty if block
        }
    }

    public void onServerLevelPostTick(class_3218 level) {
    }

    private static void scheduleNextInventoryCheck(int currentTick, int interval) {
        int offset = random.nextInt(interval);
        nextInventoryCheckTick = currentTick + offset;
    }

    public void onServerPreTick(MinecraftServer server) {
        if (server.method_3780() % 100 == 0) {
            // empty if block
        }
    }

    public void onServerPostTick(MinecraftServer server) {
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        int inventoryCheckInterval = config.inventory_check_interval;
        if (nextInventoryCheckTick == 0) {
            TickEvents.scheduleNextInventoryCheck(server.method_3780(), inventoryCheckInterval);
        }
        if (server.method_3780() >= nextInventoryCheckTick) {
            for (class_1657 player : server.method_3760().method_14571()) {
                PlayerDataUtils.checkPlayerInventory(player);
            }
            TickEvents.scheduleNextInventoryCheck(server.method_3780(), inventoryCheckInterval);
        }
        Iterator<Map.Entry<UUID, Integer>> iterator = PlayerEvents.playersToProcess.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry = iterator.next();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                class_3222 player = server.method_3760().method_14602(entry.getKey());
                if (player != null) {
                    FormAndAspectUtils.processPlayerData(player);
                }
                iterator.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
    }

    public void onPlayerPreTick(class_1657 player) {
    }

    public void onPlayerPostTick(class_1657 player) {
    }
}

