/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGuiHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;

public class ConfigGui {
    private static final int INVENTORY_SIZE = 54;

    public void openConfigGui(class_3222 player, ModConfigs config) {
        class_1277 inventory = new class_1277(54);
        int slotIndex = 0;
        this.setupToggleSetting(inventory, 0, "consume_items_on_successful_spawn", config.consume_items_on_successful_spawn, "Determines if items are consumed on successful spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 1, "ignore_key_items", config.ignore_key_items, "If true, only items are consumed. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 2, "inventory_check_shulker_boxes", config.inventory_check_shulker_boxes, "Scans Shulker Boxes for items. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 3, "inventory_check_bundles", config.inventory_check_bundles, "Scans Bundles for items. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 4, "enable_force_spawning", config.enable_force_spawning, "Force spawns Pokemon. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 5, "server_only_mode", config.server_only_mode, "Server-only mode. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 6, "force_spawning_spawn_pool", config.force_spawning_spawn_pool, "Spawn pool for force spawning. Default: ultra-rare.", Arrays.asList("common", "uncommon", "rare", "ultra-rare"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 7, "inventory_check_interval", Integer.toString(config.inventory_check_interval), "Interval in Minecraft ticks for checking player inventories. Default: 3600.", Arrays.asList("600", "1200", "1800", "3600", "7200", "14400"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 8, "force_spawn_item_cooldown", Integer.toString(config.force_spawn_item_cooldown), "Cooldown period (in seconds) after a key item is used for force spawning. Default: 20.", Arrays.asList("10", "20", "30", "60"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 18, "force_spawn_check_width", Integer.toString(config.force_spawn_check_width), "The width range for force spawning check. Default: 100.", Arrays.asList("50", "75", "100", "125", "150"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 19, "force_spawn_check_height", Integer.toString(config.force_spawn_check_height), "The height range for force spawning check. Default: 50.", Arrays.asList("25", "50", "75", "100"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupChatSetting(inventory, 20, "inventory_check_item_list", "List of items for inventory check. Click to add item.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 21, "Broadcast", config.broadcast_settings.get((int)0).settingValue, "Toggles broadcasting on and off. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 22, "DisplayName", config.broadcast_settings.get((int)1).settingValue, "Displays the name of the Pokemon in the broadcast message. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 23, "Legendarys", config.broadcast_settings.get((int)2).settingValue, "Broadcasts a message when a legendary Pokemon spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 24, "Mythicals", config.broadcast_settings.get((int)3).settingValue, "Broadcasts a message when a mythical Pokemon spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 25, "UltraBeasts", config.broadcast_settings.get((int)4).settingValue, "Broadcasts a message when an Ultra Beast spawns. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 26, "Location", config.broadcast_settings.get((int)5).settingValue, "Includes the location in broadcast messages. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 36, "Shiny", config.broadcast_settings.get((int)6).settingValue, "Enables broadcasts about Shiny Status of the Pokemon. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 37, "Level", config.broadcast_settings.get((int)7).settingValue, "Includes the level of Pokemon in the broadcast. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 38, "form_changes", config.form_changes, "Enables/Disables Form Changes. Default: true.");
        this.setupCycleSetting(inventory, 39, "join_form_aspect_delay", Integer.toString(config.join_form_aspect_delay), "The delay after a player joins the world till forms&apsects get applied. Default: 100.", Arrays.asList("60", "80", "100", "120", "140"));
        player.method_17355((class_3908)new class_747((syncId, playerInventory, playerEntity) -> new ConfigGuiHandler(syncId, playerEntity, inventory, config), class_2561.method_30163((String)"MythsAndLegends Settings")));
    }

    private int adjustSlotIndex(int slotIndex) {
        if (slotIndex % 9 == 0) {
            slotIndex += 9;
        }
        return slotIndex;
    }

    private void setupToggleSetting(class_1277 inventory, int slot, String settingName, boolean value, String description) {
        class_1799 paper = new class_1799((class_1935)class_1802.field_8407);
        this.setCustomName(paper, settingName);
        this.setLore(paper, description);
        class_1799 wool = new class_1799((class_1935)(value ? class_1802.field_19049 : class_1802.field_19058));
        this.setCustomName(wool, value ? "Enabled" : "Disabled");
        inventory.method_5447(slot, paper);
        inventory.method_5447(slot + 9, wool);
    }

    public void setupCycleSetting(class_1277 inventory, int slot, String settingName, String currentValue, String description, List<String> possibleValues) {
        class_1799 paper = new class_1799((class_1935)class_1802.field_8407);
        this.setCustomName(paper, settingName);
        this.setLore(paper, description);
        class_1799 wool = new class_1799((class_1935)class_1802.field_19054);
        this.setCustomName(wool, currentValue);
        inventory.method_5447(slot, paper);
        inventory.method_5447(slot + 9, wool);
    }

    public void setupChatSetting(class_1277 inventory, int slot, String settingName, String description) {
        class_1799 paper = new class_1799((class_1935)class_1802.field_8407);
        this.setCustomName(paper, settingName);
        this.setLore(paper, description);
        class_1799 wool = new class_1799((class_1935)class_1802.field_19045);
        this.setCustomName(wool, "Click to Add Item");
        inventory.method_5447(slot, paper);
        inventory.method_5447(slot + 9, wool);
    }

    private void setCustomName(class_1799 itemStack, String name) {
        class_2487 nbt = itemStack.method_7948();
        class_2487 display = nbt.method_10562("display");
        display.method_10582("Name", class_2561.class_2562.method_10867((class_2561)class_2561.method_30163((String)name)));
        nbt.method_10566("display", (class_2520)display);
    }

    private void setLore(class_1799 itemStack, String description) {
        class_2487 nbt = itemStack.method_7948();
        class_2487 display = nbt.method_10562("display");
        class_2499 lore = new class_2499();
        lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_30163((String)description))));
        display.method_10566("Lore", (class_2520)lore);
        nbt.method_10566("display", (class_2520)display);
    }
}

