/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5537;
import net.minecraft.class_7923;

public class PlayerDataUtils {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static final DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
    private static ModConfigs modConfig;

    public static void setModConfig(ModConfigs config) {
        modConfig = config;
    }

    public static PlayerData getPlayerData(class_1657 player) {
        return playerDataMap.computeIfAbsent(player.method_5667(), k -> new PlayerData());
    }

    public static void checkPlayerInventory(class_1657 player) {
        class_1792 configItem;
        HashSet<class_1792> itemsToCheck = new HashSet<class_1792>();
        for (class_2960 class_29602 : Items.MYTHS_AND_LEGENDS_ITEMS) {
            configItem = (class_1792)class_7923.field_41178.method_10223(class_29602);
            itemsToCheck.add(configItem);
        }
        for (String string : PlayerDataUtils.modConfig.inventory_check_item_list) {
            configItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(string));
            itemsToCheck.add(configItem);
        }
        PlayerData data = PlayerDataUtils.getPlayerData(player);
        for (class_1792 item : itemsToCheck) {
            data.setItemCount(item, 0);
        }
        HashMap<class_1792, Integer> hashMap = new HashMap<class_1792, Integer>();
        debtUtils.loadDebts();
        Map<class_2960, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.method_5667());
        if (!playerDebts.isEmpty()) {
            for (Map.Entry entry : playerDebts.entrySet()) {
                int debtCount;
                class_2960 debtItemId = (class_2960)entry.getKey();
                class_1792 debtItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(debtItemId.method_12836(), debtItemId.method_12832()));
                if (!InventoryUtils.removeItemFromInventory((class_3222)player, debtItem, debtCount = ((Integer)entry.getValue()).intValue(), false, false)) continue;
                debtUtils.clearDebt(player.method_5667(), debtItemId);
            }
        }
        for (class_1799 class_17992 : player.method_31548().field_7547) {
            if (itemsToCheck.contains(class_17992.method_7909())) {
                data.setItemState(class_17992.method_7909(), true);
                hashMap.merge(class_17992.method_7909(), class_17992.method_7947(), Integer::sum);
            }
            if (PlayerDataUtils.modConfig.inventory_check_bundles && class_17992.method_7909() instanceof class_5537) {
                PlayerDataUtils.checkItemsInContainer(class_17992, data, itemsToCheck, hashMap, player);
            }
            if (!PlayerDataUtils.modConfig.inventory_check_shulker_boxes || !(class_17992.method_7909() instanceof class_1747) || !(((class_1747)class_17992.method_7909()).method_7711() instanceof class_2480)) continue;
            PlayerDataUtils.checkItemsInContainer(class_17992, data, itemsToCheck, hashMap, player);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            data.setItemCount((class_1792)entry.getKey(), (Integer)entry.getValue());
        }
    }

    private static void checkItemsInContainer(class_1799 containerStack, PlayerData data, Set<class_1792> itemsToCheck, Map<class_1792, Integer> totalItemCounts, class_1657 player) {
        block5: {
            class_2487 compoundTag;
            class_1792 containerItem;
            block4: {
                containerItem = containerStack.method_7909();
                Map<class_2960, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.method_5667());
                if (!playerDebts.isEmpty()) {
                    for (Map.Entry<class_2960, Integer> debtEntry : playerDebts.entrySet()) {
                        int debtCount;
                        class_2960 debtItemId = debtEntry.getKey();
                        class_1792 debtItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(debtItemId.method_12836(), debtItemId.method_12832()));
                        if (!InventoryUtils.removeItemFromInventory((class_3222)player, debtItem, debtCount = debtEntry.getValue().intValue(), true, true)) continue;
                        debtUtils.clearDebt(player.method_5667(), debtItemId);
                    }
                }
                if (!(containerItem instanceof class_5537)) break block4;
                compoundTag = containerStack.method_7948();
                class_2499 itemsTag = compoundTag.method_10554("Items", 10);
                for (int i = 0; i < itemsTag.size(); ++i) {
                    class_2487 itemTag = itemsTag.method_10602(i);
                    class_1799 bundleItem = class_1799.method_7915((class_2487)itemTag);
                    if (!itemsToCheck.contains(bundleItem.method_7909())) continue;
                    data.setItemState(bundleItem.method_7909(), true);
                    totalItemCounts.merge(bundleItem.method_7909(), bundleItem.method_7947(), Integer::sum);
                }
                break block5;
            }
            if (!(containerItem instanceof class_1747) || !(((class_1747)containerItem).method_7711() instanceof class_2480) || !(compoundTag = containerStack.method_7948()).method_10545("BlockEntityTag")) break block5;
            class_2487 blockEntityTag = compoundTag.method_10562("BlockEntityTag");
            class_2499 itemsTag = blockEntityTag.method_10554("Items", 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                class_2487 itemTag = itemsTag.method_10602(i);
                class_1799 shulkerItem = class_1799.method_7915((class_2487)itemTag);
                if (!itemsToCheck.contains(shulkerItem.method_7909())) continue;
                data.setItemState(shulkerItem.method_7909(), true);
                totalItemCounts.merge(shulkerItem.method_7909(), shulkerItem.method_7947(), Integer::sum);
            }
        }
    }

    public static class PlayerData {
        private final Map<class_1792, Boolean> itemStates = new HashMap<class_1792, Boolean>();
        private final Map<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();

        public void setItemState(class_1792 item, boolean hasItem) {
            if (hasItem) {
                this.itemStates.putIfAbsent(item, hasItem);
            } else {
                this.itemStates.remove(item);
            }
        }

        public boolean hasItem(class_1792 item) {
            return this.itemStates.getOrDefault(item, false);
        }

        public void setItemCount(class_1792 item, int count) {
            if (count <= 0) {
                this.itemCounts.remove(item);
            } else {
                this.itemCounts.put(item, count);
            }
        }

        public int getItemCount(class_1792 item) {
            return this.itemCounts.getOrDefault(item, 0);
        }

        public String getFormattedItemsWithCounts() {
            StringBuilder itemsWithCounts = new StringBuilder();
            for (Map.Entry<class_1792, Boolean> entry : this.itemStates.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                String itemName = entry.getKey().method_7848().getString();
                int itemCount = this.itemCounts.getOrDefault(entry.getKey(), 0);
                itemsWithCounts.append(itemName).append(": ").append(itemCount).append(", ");
            }
            if (!itemsWithCounts.isEmpty()) {
                itemsWithCounts = new StringBuilder(itemsWithCounts.substring(0, itemsWithCounts.length() - 2));
            }
            return itemsWithCounts.toString();
        }
    }
}

