/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PokemonJsonStorageUtil {
    private static String POKEMON_FILE;
    private static Map<UUID, JsonObject> pokemonDataMap;
    private static Gson gson;

    public PokemonJsonStorageUtil(Path configDirectoryPath) {
        POKEMON_FILE = configDirectoryPath.resolve("pokemon_data.json").toAbsolutePath().toString();
        gson = new GsonBuilder().setPrettyPrinting().create();
        this.loadPokemonData();
    }

    public Map<UUID, JsonObject> getPokemonDataMap() {
        return pokemonDataMap;
    }

    public JsonObject getPokemonData(UUID playerId) {
        return pokemonDataMap.getOrDefault(playerId, new JsonObject());
    }

    public static void savePokemonData(UUID playerId, JsonObject pokemonData) {
        pokemonDataMap.put(playerId, pokemonData);
        PokemonJsonStorageUtil.savePokemonDataToFile();
    }

    public void clearPokemonData(UUID playerId) {
        pokemonDataMap.remove(playerId);
        PokemonJsonStorageUtil.savePokemonDataToFile();
    }

    public boolean hasPokemonData(UUID playerId) {
        return pokemonDataMap.containsKey(playerId);
    }

    private static void savePokemonDataToFile() {
        try (FileWriter writer = new FileWriter(POKEMON_FILE);){
            gson.toJson(pokemonDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.LOGGER.error("Failed to save Pok\u00e9mon data to file: " + POKEMON_FILE);
        }
    }

    private void loadPokemonData() {
        File file = new File(POKEMON_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
                pokemonDataMap = new HashMap<UUID, JsonObject>();
                PokemonJsonStorageUtil.savePokemonDataToFile();
            }
            catch (IOException e) {
                MythsAndLegends.LOGGER.error("Failed to create Pok\u00e9mon data file: " + POKEMON_FILE);
            }
        } else {
            try (FileReader reader = new FileReader(file);){
                pokemonDataMap = (Map)gson.fromJson((Reader)reader, new TypeToken<HashMap<UUID, JsonObject>>(){}.getType());
            }
            catch (IOException e) {
                MythsAndLegends.LOGGER.error("Failed to load Pok\u00e9mon data from file: " + POKEMON_FILE);
            }
        }
    }

    static {
        pokemonDataMap = new ConcurrentHashMap<UUID, JsonObject>();
    }
}

