/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.ScreenshotLoader;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_318;
import net.minecraft.class_5498;
import org.slf4j.Logger;

public class OnLeaveHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean attemptScreenShot = false;
    public static Runnable onceFinished = () -> {};
    private static int old_FrameBufferWidth = 0;
    private static int old_FrameBufferHeight = 0;

    public static void beginScreenshotTask(Runnable runnable) {
        if (ScreenshotLoader.displayMode == DisplayMode.FREEZE) {
            runnable.run();
            return;
        }
        attemptScreenShot = true;
        onceFinished = runnable;
        class_315 options = class_310.method_1551().field_1690;
        options.method_31043(class_5498.field_26664);
        options.field_1866 = false;
        options.field_1880 = false;
        options.field_1893 = false;
        class_1041 window = class_310.method_1551().method_22683();
        old_FrameBufferWidth = window.method_4489();
        old_FrameBufferHeight = window.method_4506();
        window.method_35642(Config.get().resolution.width);
        window.method_35643(Config.get().resolution.height);
        class_310.method_1551().method_15993();
    }

    public static void takeScreenShot() {
        class_310 client = class_310.method_1551();
        String name = ScreenshotLoader.getFileName();
        class_1011 nativeImage = class_318.method_1663((class_276)client.method_1522());
        try {
            File file = new File(name);
            if (!file.exists()) {
                file.createNewFile();
            }
            nativeImage.method_4325(new File(name));
            if (Config.get().archiveScreenshots) {
                String fileName = "screenshots/worlds/archive/" + name.substring(name.lastIndexOf("/"), name.length() - 4) + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".png";
                File archiveFile = new File(fileName);
                if (!archiveFile.exists()) {
                    archiveFile.createNewFile();
                }
                nativeImage.method_4325(archiveFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("[SeamlessLoadingScreen]: Unable to take a screenshot on leaving of a world, such will not be saved! [Name: {}]", (Object)name);
            LOGGER.error(e.toString());
        }
        if (Config.get().updateWorldIcon && client.method_1542()) {
            OnLeaveHelper.updateIcon(((Path)client.method_1576().method_3725().get()).toFile(), nativeImage);
        }
        attemptScreenShot = false;
        class_1041 window = class_310.method_1551().method_22683();
        window.method_35642(old_FrameBufferWidth);
        window.method_35643(old_FrameBufferHeight);
        client.method_15993();
        onceFinished.run();
        onceFinished = () -> {};
    }

    private static void updateIcon(File iconFile, class_1011 nativeImage) {
        class_156.method_27958().execute(() -> {
            int i = nativeImage.method_4307();
            int j = nativeImage.method_4323();
            int k = 0;
            int l = 0;
            if (i > j) {
                k = (i - j) / 2;
                i = j;
            } else {
                l = (j - i) / 2;
                j = i;
            }
            try (class_1011 nativeImage2 = new class_1011(64, 64, false);){
                nativeImage.method_4300(k, l, i, j, nativeImage2);
                nativeImage2.method_4325(iconFile);
            }
            catch (IOException e) {
                LOGGER.error("[SeamlessLoadingScreen] Unable to update the world icon!", (Throwable)e);
            }
            finally {
                nativeImage.close();
            }
        });
    }
}

