/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.PlatformFunctions;
import com.minenash.seamless_loading_screen.SeamlessLoadingScreen;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_155;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30;
import org.slf4j.Logger;

public class ScreenshotLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static class_2960 SCREENSHOT = new class_2960("seamless_loading_screen", "screenshot");
    public static double imageRatio = 1.0;
    public static boolean loaded = false;
    public static DisplayMode displayMode = DisplayMode.ENABLED;
    public static boolean inFade = false;
    public static int time;
    public static float timeDelta;
    private static String fileName;
    private static final Pattern RESERVED_FILENAMES_PATTERN;
    public static boolean replacebg;

    public static String getFileName() {
        return fileName;
    }

    public static void setScreenshot(String address, int port) {
        ScreenshotLoader.setFileName("screenshots/worlds/servers/" + ScreenshotLoader.cleanFileName(address) + "_" + port + ".png");
    }

    public static void setScreenshot(String worldName) {
        ScreenshotLoader.setFileName("screenshots/worlds/singleplayer/" + worldName + ".png");
    }

    public static void setRealmScreenshot(String realmName) {
        ScreenshotLoader.setFileName("screenshots/worlds/realms/" + ScreenshotLoader.cleanFileName(realmName) + ".png");
    }

    private static void setFileName(String newFileName) {
        fileName = newFileName;
        ScreenshotLoader.setScreenshot();
    }

    private static void setScreenshot() {
        loaded = false;
        if (displayMode == DisplayMode.DISABLED) {
            return;
        }
        try (FileInputStream in2 = new FileInputStream(fileName);){
            if (PlatformFunctions.isDevEnv()) {
                LOGGER.info("Name: " + fileName);
            }
            class_1043 image = new class_1043(class_1011.method_4309((InputStream)in2));
            class_310.method_1551().method_1531().method_4616(SCREENSHOT, (class_1044)image);
            imageRatio = (double)image.method_4525().method_4307() / (double)image.method_4525().method_4323();
            loaded = true;
            time = Config.get().time;
            timeDelta = 1.0f / (float)Config.get().fade;
            replacebg = true;
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            LOGGER.error("[SeamlessLoadingScreen]: An Issue has occurred when attempting to set a Screenshot: [name: {}]", (Object)fileName);
            LOGGER.error(String.valueOf(e));
        }
    }

    private static String cleanFileName(String fileName) {
        for (char c : class_155.field_1126) {
            fileName = ((String)fileName).replace(c, '_');
        }
        if (RESERVED_FILENAMES_PATTERN.matcher((CharSequence)fileName).matches()) {
            fileName = "_" + (String)fileName + "_";
        }
        if (((String)fileName).length() > 251) {
            fileName = ((String)fileName).substring(0, 251);
        }
        return fileName;
    }

    public static void render(class_437 screen, class_332 context) {
        RenderSystem.enableBlend();
        int w = (int)(imageRatio * (double)screen.field_22790);
        context.method_25290(SCREENSHOT, screen.field_22789 / 2 - w / 2, 0, 0.0f, 0.0f, w, screen.field_22790, w, screen.field_22790);
        ScreenshotLoader.renderAfterEffects(screen, context, 1.0f);
        RenderSystem.disableBlend();
    }

    public static void renderAfterEffects(class_437 screen, class_332 context, float fadeValue) {
        ScreenshotLoader.renderTint(screen, context, fadeValue);
        if (Config.get().enableScreenshotBlur && SeamlessLoadingScreen.BLUR_PROGRAM.loaded) {
            ScreenshotLoader.renderBlur(screen, context, Config.get().screenshotBlurStrength * fadeValue, Config.get().screenshotBlurQuality);
        }
    }

    public static void renderTint(class_437 screen, class_332 context, float fadeValue) {
        Color color = Config.get().tintColor;
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = Math.round(255.0f * (Config.get().tintStrength * fadeValue));
        int argb_color = ScreenshotLoader.getArgb(alpha, red, green, blue);
        context.method_25294(0, 0, screen.field_22789, screen.field_22790, argb_color);
    }

    public static int getArgb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static void renderBlur(class_437 screen, class_332 context, float size, float quality) {
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, 0.0f, (float)screen.field_22790, 0.0f).method_1344();
        buffer.method_22918(matrix, (float)screen.field_22789, (float)screen.field_22790, 0.0f).method_1344();
        buffer.method_22918(matrix, (float)screen.field_22789, 0.0f, 0.0f).method_1344();
        SeamlessLoadingScreen.BLUR_PROGRAM.setParameters(16, quality, size);
        SeamlessLoadingScreen.BLUR_PROGRAM.use();
        class_289.method_1348().method_1350();
    }

    static {
        fileName = "";
        RESERVED_FILENAMES_PATTERN = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
        replacebg = false;
    }

    public static class BlurHelper {
        private class_284 inputResolution;
        private class_284 directions;
        private class_284 quality;
        private class_284 size;
        private class_276 input;
        private class_5944 backingProgram;
        public boolean loaded = false;

        public void onWindowResize(class_310 client, class_1041 window) {
            if (this.input == null) {
                return;
            }
            this.input.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
        }

        public void load(class_5944 backingProgram) {
            this.backingProgram = backingProgram;
            this.setup();
            this.loaded = true;
        }

        public void setParameters(int directions, float quality, float size) {
            this.directions.method_1251((float)directions);
            this.size.method_1251(size);
            this.quality.method_1251(quality);
        }

        public void use() {
            class_276 buffer = class_310.method_1551().method_1522();
            this.input.method_1235(false);
            GL30.glBindFramebuffer((int)36008, (int)buffer.field_1476);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)buffer.field_1482, (int)buffer.field_1481, (int)0, (int)0, (int)buffer.field_1482, (int)buffer.field_1481, (int)16384, (int)9729);
            buffer.method_1235(false);
            this.inputResolution.method_1255((float)buffer.field_1482, (float)buffer.field_1481);
            this.backingProgram.method_34583("InputSampler", (Object)this.input.method_30277());
            RenderSystem.setShader(() -> this.backingProgram);
        }

        protected void setup() {
            this.inputResolution = this.findUniform("InputResolution");
            this.directions = this.findUniform("Directions");
            this.quality = this.findUniform("Quality");
            this.size = this.findUniform("Size");
            class_1041 window = class_310.method_1551().method_22683();
            this.input = new class_6367(window.method_4489(), window.method_4506(), false, class_310.field_1703);
        }

        private class_284 findUniform(String key) {
            return this.backingProgram.method_34582(key);
        }
    }
}

