/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen.config;

import com.google.gson.GsonBuilder;
import com.minenash.seamless_loading_screen.PlatformFunctions;
import com.minenash.seamless_loading_screen.config.SafeColorTypeAdapter;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.ConfigEntry;
import dev.isxander.yacl3.config.GsonConfigInstance;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3417;

public class Config {
    private static final SafeColorTypeAdapter colorAdapter = new SafeColorTypeAdapter(() -> Config.getDefaults().tintColor);
    private static final GsonConfigInstance<Config> GSON = GsonConfigInstance.createBuilder(Config.class).overrideGsonBuilder(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_2562()).registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584()).registerTypeHierarchyAdapter(Color.class, (Object)colorAdapter)).setPath(PlatformFunctions.getConfigDirectory().resolve("seamless_loading_screen.json")).build();
    @ConfigEntry
    public int time = 80;
    @ConfigEntry
    public int fade = 20;
    @ConfigEntry
    public Color tintColor = new Color(0x212121);
    @ConfigEntry
    public float tintStrength = 0.3f;
    @ConfigEntry
    public boolean enableScreenshotBlur = false;
    @ConfigEntry
    public float screenshotBlurStrength = 1.0f;
    @ConfigEntry
    public float screenshotBlurQuality = 5.0f;
    @ConfigEntry
    public boolean playSoundEffect = false;
    @ConfigEntry
    public String soundEffect = class_3417.field_14641.method_14833().toString();
    @ConfigEntry
    public float soundPitch = 1.0f;
    @ConfigEntry
    public float soundVolume = 1.0f;
    @ConfigEntry
    public ScreenshotResolution resolution = ScreenshotResolution.Normal;
    @ConfigEntry
    public boolean disableCamera = true;
    @ConfigEntry
    public boolean archiveScreenshots = false;
    @ConfigEntry
    public boolean updateWorldIcon = false;
    @ConfigEntry
    public List<String> blacklistedAddresses = List.of("play.wynncraft.com");

    private static Config getDefaults() {
        return (Config)GSON.getDefaults();
    }

    public static Config get() {
        return (Config)GSON.getConfig();
    }

    public static void load() {
        GSON.load();
        if (colorAdapter.errored()) {
            GSON.save();
        }
    }

    public static void save() {
        GSON.save();
    }

    private static class_2561 getName(String id) {
        return class_2561.method_43471((String)("seamless_loading_screen.config." + id));
    }

    private static class_2561 getDesc(String id) {
        return class_2561.method_43471((String)("seamless_loading_screen.config." + id + ".description"));
    }

    public static YetAnotherConfigLib getInstance() {
        return YetAnotherConfigLib.create(GSON, (defaults, config, builder) -> {
            Option timeOpt = Option.createBuilder().name(Config.getName("time")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("time")}).build()).binding((Object)defaults.time, () -> config.time, val -> {
                config.time = val;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).min((Number)0)).build();
            Option fadeOpt = Option.createBuilder().name(Config.getName("fade")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("fade")}).build()).binding((Object)defaults.fade, () -> config.fade, val -> {
                config.fade = val;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).min((Number)0)).build();
            Option disableCameraOpt = Option.createBuilder().name(Config.getName("disableCamera")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("disableCamera")}).build()).binding((Object)defaults.disableCamera, () -> config.disableCamera, val -> {
                config.disableCamera = val;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option soundOpt = Option.createBuilder().name(Config.getName("soundEffect")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("soundEffect")}).build()).binding((Object)defaults.soundEffect, () -> config.soundEffect, val -> {
                config.soundEffect = val;
            }).controller(StringControllerBuilder::create).build();
            Option soundPitchOpt = Option.createBuilder().name(Config.getName("soundPitch")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("soundPitch")}).build()).binding((Object)Float.valueOf(defaults.soundPitch), () -> Float.valueOf(config.soundPitch), val -> {
                config.soundPitch = val.floatValue();
            }).controller(opt -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)opt).min((Number)Float.valueOf(0.0f))).max((Number)Float.valueOf(10.0f))).build();
            Option soundVolumeOpt = Option.createBuilder().name(Config.getName("soundVolume")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("soundVolume")}).build()).binding((Object)Float.valueOf(defaults.soundVolume), () -> Float.valueOf(config.soundVolume), val -> {
                config.soundVolume = val.floatValue();
            }).controller(opt -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)opt).min((Number)Float.valueOf(0.0f))).max((Number)Float.valueOf(10.0f))).build();
            Option playSoundEffectOpt = Option.createBuilder().name(Config.getName("playSoundEffect")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("playSoundEffect")}).build()).binding((Object)defaults.playSoundEffect, () -> config.playSoundEffect, val -> {
                config.playSoundEffect = val;
            }).listener((opt, val) -> {
                soundPitchOpt.setAvailable(val.booleanValue());
                soundVolumeOpt.setAvailable(val.booleanValue());
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            Option screenshotBlurStrengthOpt = Option.createBuilder().name(Config.getName("screenshotBlurStrength")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("screenshotBlurStrength")}).build()).binding((Object)Float.valueOf(defaults.screenshotBlurStrength), () -> Float.valueOf(config.screenshotBlurStrength), val -> {
                config.screenshotBlurStrength = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(1.0f), (Number)Float.valueOf(16.0f))).step((Number)Float.valueOf(0.1f))).build();
            Option screenshotBlurQualityOpt = Option.createBuilder().name(Config.getName("screenshotBlurQuality")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("screenshotBlurQuality")}).build()).binding((Object)Float.valueOf(defaults.screenshotBlurQuality), () -> Float.valueOf(config.screenshotBlurQuality), val -> {
                config.screenshotBlurQuality = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(1.0f), (Number)Float.valueOf(16.0f))).step((Number)Float.valueOf(0.1f))).build();
            Option enableScreenshotBlurOpt = Option.createBuilder().name(Config.getName("enableScreenshotBlur")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("enableScreenshotBlur")}).build()).binding((Object)defaults.enableScreenshotBlur, () -> config.enableScreenshotBlur, val -> {
                config.enableScreenshotBlur = val;
            }).listener((opt, val) -> {
                screenshotBlurQualityOpt.setAvailable(val.booleanValue());
                screenshotBlurStrengthOpt.setAvailable(val.booleanValue());
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            Option tintColorOpt = Option.createBuilder().name(Config.getName("tintColor")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("tintColor")}).build()).binding((Object)defaults.tintColor, () -> config.tintColor, val -> {
                config.tintColor = val;
            }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(false)).build();
            Option tintStrengthOpt = Option.createBuilder().name(Config.getName("tintStrength")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("tintStrength")}).build()).binding((Object)Float.valueOf(defaults.tintStrength), () -> Float.valueOf(config.tintStrength), val -> {
                config.tintStrength = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.05f))).build();
            Option archiveScreenshotsOpt = Option.createBuilder().name(Config.getName("archiveScreenshots")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("archiveScreenshots")}).build()).binding((Object)defaults.archiveScreenshots, () -> config.archiveScreenshots, val -> {
                config.archiveScreenshots = val;
            }).controller(BooleanControllerBuilder::create).build();
            Option resolutionOpt = Option.createBuilder().name(Config.getName("resolution")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("resolution")}).build()).binding((Object)defaults.resolution, () -> config.resolution, val -> {
                config.resolution = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(ScreenshotResolution.class).valueFormatter(val -> class_2561.method_43471((String)("seamless_loading_screen.config.resolution." + val.name().toLowerCase())))).build();
            Option updateWorldIconOpt = Option.createBuilder().name(Config.getName("updateWorldIcon")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("updateWorldIcon")}).build()).binding((Object)defaults.updateWorldIcon, () -> config.updateWorldIcon, val -> {
                config.updateWorldIcon = val;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            ListOption blacklistedAddressOpt = ListOption.createBuilder().name(Config.getName("blacklistedAddresses")).description(OptionDescription.createBuilder().text(new class_2561[]{Config.getDesc("blacklistedAddresses")}).build()).binding(defaults.blacklistedAddresses, () -> config.blacklistedAddresses, val -> {
                config.blacklistedAddresses = val;
            }).controller(StringControllerBuilder::create).initial((Object)"").build();
            return builder.title(Config.getName("title")).category(ConfigCategory.createBuilder().name(Config.getName("display")).tooltip(new class_2561[]{Config.getDesc("display")}).options(List.of(timeOpt, fadeOpt, disableCameraOpt)).group(OptionGroup.createBuilder().name(Config.getName("soundEffects")).options(List.of(playSoundEffectOpt, soundOpt, soundVolumeOpt, soundPitchOpt)).build()).group(OptionGroup.createBuilder().name(Config.getName("screenshotBlur")).options(List.of(enableScreenshotBlurOpt, screenshotBlurQualityOpt, screenshotBlurStrengthOpt)).build()).group(OptionGroup.createBuilder().name(Config.getName("tint")).options(List.of(tintColorOpt, tintStrengthOpt)).build()).build()).category(ConfigCategory.createBuilder().name(Config.getName("capturing")).tooltip(new class_2561[]{Config.getDesc("capturing")}).options(List.of(archiveScreenshotsOpt, resolutionOpt, updateWorldIconOpt)).build()).category(ConfigCategory.createBuilder().name(Config.getName("server_settings")).tooltip(new class_2561[]{Config.getDesc("server_settings")}).group((OptionGroup)blacklistedAddressOpt).build());
        });
    }

    public static enum ScreenshotResolution {
        Native(0, 0),
        Normal(4000, 1600),
        r4K(4000, 2160),
        r8K(7900, 4320);

        public int width;
        public int height;

        private ScreenshotResolution(int width_in, int height_in) {
            this.width = width_in;
            this.height = height_in;
        }
    }
}

