/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.teacon.slides.Slideshow;
import org.teacon.slides.http.client.cache.HttpCacheEntry;
import org.teacon.slides.http.client.cache.Resource;
import org.teacon.slides.http.impl.client.cache.FileResource;

public final class LegacyStorage {
    private static final Path LOCAL_CACHE_MAP_JSON_PATH = Paths.get("map.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final TypeToken<Map<String, String>> LOCAL_CACHE_MAP_TYPE = new TypeToken<Map<String, String>>(){};

    static boolean loadLegacy(Path parentPath, Map<String, Pair<Path, HttpCacheEntry>> map) {
        Path path = parentPath.resolve(LOCAL_CACHE_MAP_JSON_PATH);
        if (Files.exists(path, new LinkOption[0])) {
            boolean bl;
            block10: {
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    Map stringMap = (Map)GSON.fromJson((Reader)reader, LOCAL_CACHE_MAP_TYPE.getType());
                    for (Map.Entry entry : stringMap.entrySet()) {
                        Path entryPath = Paths.get((String)entry.getValue(), new String[0]);
                        String keyString = LegacyStorage.normalizeUri((String)entry.getKey());
                        FileResource resource = new FileResource(entryPath.toFile());
                        HttpCacheEntry cacheEntry = LegacyStorage.createDummyCacheEntry(entryPath, resource);
                        map.put(keyString, (Pair<Path, HttpCacheEntry>)Pair.of((Object)entryPath, (Object)cacheEntry));
                    }
                    Files.delete(path);
                    bl = true;
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Slideshow.LOGGER.error("Failed to load from legacy cache storage. ", (Throwable)e);
                    }
                }
                reader.close();
            }
            return bl;
        }
        return false;
    }

    private static HttpCacheEntry createDummyCacheEntry(Path entryPath, Resource resource) throws IOException {
        Date dummyDate = new Date(Files.getLastModifiedTime(entryPath, new LinkOption[0]).toMillis());
        Header[] headers = new Header[]{new BasicHeader("Date", DateUtils.formatDate(dummyDate))};
        BasicStatusLine dummyStatus = new BasicStatusLine(HttpVersion.HTTP_1_1, 200, "OK");
        return new HttpCacheEntry(dummyDate, dummyDate, (StatusLine)dummyStatus, headers, resource, Collections.emptyMap());
    }

    private static String normalizeUri(String uriString) {
        try {
            URI uri = URI.create(uriString);
            URL url = new URL(uri.toASCIIString());
            String protocol = url.getProtocol();
            String hostname = url.getHost();
            String path = url.getPath();
            String query = url.getQuery();
            String file = LegacyStorage.normalizeFile(path, query);
            return new URL(protocol, hostname, LegacyStorage.normalizePort(url.getPort(), protocol), file).toString();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return uriString;
        }
    }

    private static String normalizeFile(String path, @Nullable String query) {
        return query == null ? path : path + "?" + query;
    }

    private static int normalizePort(int port, String protocol) {
        if (port == -1) {
            if ("http".equalsIgnoreCase(protocol)) {
                return 80;
            }
            if ("https".equalsIgnoreCase(protocol)) {
                return 443;
            }
        }
        return port;
    }
}

