/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public interface IngredientJS {
    public static class_1856 of(@Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == class_1799.field_8037 || o == class_1802.field_8162 || o == class_1856.field_9017) {
            return class_1856.field_9017;
        }
        if (o instanceof IngredientSupplierKJS) {
            IngredientSupplierKJS ingr = (IngredientSupplierKJS)o;
            return ingr.kjs$asIngredient();
        }
        if (o instanceof class_6862) {
            class_6862 tag = (class_6862)o;
            return class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag.comp_327()));
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return IngredientPlatformHelper.get().regex(reg);
            }
            return class_1856.field_9017;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return IngredientJS.ofJson(json);
        }
        if (o instanceof CharSequence) {
            return IngredientJS.parse(o.toString());
        }
        List<?> list = ListJS.of(o);
        if (list != null) {
            ArrayList<class_1856> inList = new ArrayList<class_1856>(list.size());
            for (Object o1 : list) {
                class_1856 ingredient = IngredientJS.of(o1);
                if (ingredient == class_1856.field_9017) continue;
                inList.add(ingredient);
            }
            if (inList.isEmpty()) {
                return class_1856.field_9017;
            }
            if (inList.size() == 1) {
                return (class_1856)inList.get(0);
            }
            return IngredientPlatformHelper.get().or(inList.toArray(new class_1856[0]));
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            class_1856 in = class_1856.field_9017;
            boolean val = map.containsKey("value");
            if (map.containsKey("type")) {
                if ("forge:nbt".equals(map.get("type"))) {
                    in = ItemStackJS.of(map.get("item")).kjs$withNBT(NBTUtils.toTagCompound(map.get("nbt"))).kjs$strongNBT();
                } else {
                    JsonObject json = MapJS.json(o);
                    if (json == null) {
                        throw new RecipeExceptionJS("Failed to parse custom ingredient (" + o + " is not a json object");
                    }
                    try {
                        in = RecipePlatformHelper.get().getCustomIngredient(json);
                    }
                    catch (Exception ex) {
                        throw new RecipeExceptionJS("Failed to parse custom ingredient (" + json.get("type") + ") from " + json + ": " + ex);
                    }
                }
            } else if (val || map.containsKey("ingredient")) {
                in = IngredientJS.of(val ? map.get("value") : map.get("ingredient"));
            } else if (map.containsKey("tag")) {
                in = IngredientPlatformHelper.get().tag(map.get("tag").toString());
            } else if (map.containsKey("item")) {
                in = ItemStackJS.of(map).method_7909().kjs$asIngredient();
            }
            return in;
        }
        return ItemStackJS.of(o).kjs$asIngredient();
    }

    public static class_1856 parse(String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return class_1856.field_9017;
        }
        if (s.equals("*")) {
            return IngredientPlatformHelper.get().wildcard();
        }
        if (s.startsWith("#")) {
            return IngredientPlatformHelper.get().tag(s.substring(1));
        }
        if (s.startsWith("@")) {
            return IngredientPlatformHelper.get().mod(s.substring(1));
        }
        if (s.startsWith("%")) {
            class_1761 group = UtilsJS.findCreativeTab(new class_2960(s.substring(1)));
            if (group == null) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                }
                return class_1856.field_9017;
            }
            return IngredientPlatformHelper.get().creativeTab(group);
        }
        Pattern reg = UtilsJS.parseRegex(s);
        if (reg != null) {
            return IngredientPlatformHelper.get().regex(reg);
        }
        class_1792 item = RegistryInfo.ITEM.getValue(new class_2960(s));
        if (item == null || item == class_1802.field_8162) {
            return class_1856.field_9017;
        }
        return item.kjs$asIngredient();
    }

    public static class_1856 ofJson(JsonElement json) {
        if (json == null || json.isJsonNull() || json.isJsonArray() && json.getAsJsonArray().isEmpty()) {
            return class_1856.field_9017;
        }
        if (json.isJsonPrimitive()) {
            return IngredientJS.of(json.getAsString());
        }
        return class_1856.method_52177((JsonElement)json);
    }

    public static class_1856 ofNetwork(class_2540 buf) {
        return class_1856.method_8086((class_2540)buf);
    }
}

