/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1430;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class CowJarHandler {
    private static final List<Class<? extends class_1309>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        if (!CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            return;
        }
        if (event.getDamageSource().method_5525().equals("anvil") && CowJarHandler.isCow(event.getEntity())) {
            class_1309 entity = event.getEntity();
            class_2338 pos = entity.method_24515();
            class_1937 level = entity.method_37908();
            class_2680 blockBelow = level.method_8320(pos);
            if (blockBelow.method_26204() == ModBlocks.milkJar) {
                boolean wasCompressed;
                level.method_8501(pos, ModBlocks.cowJar.method_9564());
                class_2586 tileEntity = level.method_8321(pos);
                if (tileEntity instanceof CowJarBlockEntity && entity.method_5797() != null) {
                    class_5250 textComponent = class_2561.method_43469((String)"container.cookingforblockheads.cow_jar_custom", (Object[])new Object[]{entity.method_5797()});
                    ((CowJarBlockEntity)tileEntity).setCustomName((class_2561)textComponent);
                }
                if ((wasCompressed = Balm.getHooks().getPersistentData((class_1297)event.getEntity()).method_10562("excompressum").method_10577("Compressed")) && tileEntity instanceof CowJarBlockEntity) {
                    ((CowJarBlockEntity)tileEntity).setCompressedCow(true);
                }
            }
            Balm.getNetworking().sendToTracking((class_1297)entity, (Object)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.COW_IN_A_JAR));
            entity.method_5650(class_1297.class_5529.field_26999);
            event.setCanceled(true);
        }
    }

    public static boolean isCow(class_1309 entity) {
        if (entity instanceof class_1430) {
            return true;
        }
        for (Class<? extends class_1309> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        class_2960 registryName = Balm.getRegistries().getKey(entity.method_5864());
        return registryName != null && registryName.method_12832().contains("cow");
    }
}

