/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.InternalClientMethodsImpl;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksDebugger;
import net.blay09.mods.craftingtweaks.client.ModKeyMappings;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.network.CraftStackMessage;
import net.blay09.mods.craftingtweaks.network.TransferStackMessage;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;

public class CraftingTweaksClient {
    private static final ClientProvider clientProvider = new ClientProvider();
    private static boolean ignoreMouseUp;
    private static int rightClickCraftingSlot;
    private static class_4185 unpleasantButton;
    private static int fixedUnpleasantButtonX;

    public static void initialize() {
        CraftingTweaksClientAPI.setupAPI(new InternalClientMethodsImpl());
        CraftingTweaksClientAPI.registerCraftingGridGuiHandler(class_465.class, new DefaultGridGuiHandler());
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ItemCraftedEvent.class, CraftingTweaksClient::onItemCrafted);
        Balm.getEvents().onEvent(ConnectedToServerEvent.class, it -> {
            CraftingTweaks.isServerSideInstalled = false;
        });
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, CraftingTweaksClient::screenInitialized);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, CraftingTweaksClient::screenKeyPressed);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, CraftingTweaksClient::screenMouseClick);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, CraftingTweaksClient::screenMouseRelease);
        Balm.getEvents().onEvent(ScreenDrawEvent.Pre.class, CraftingTweaksClient::screenAboutToDraw);
        Balm.getEvents().onEvent(ScreenDrawEvent.Post.class, CraftingTweaksClient::screenDrawn);
        CraftingTweaksDebugger.initialize();
    }

    public static void screenKeyPressed(ScreenKeyEvent event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_1041 window = class_310.method_1551().method_22683();
            if (CraftingTweaks.isServerSideInstalled && GLFW.glfwGetKey((long)window.method_4490(), (int)66) == 1 && GLFW.glfwGetKey((long)window.method_4490(), (int)76) == 1 && GLFW.glfwGetKey((long)window.method_4490(), (int)65) == 1 && (GLFW.glfwGetKey((long)window.method_4490(), (int)89) == 1 || GLFW.glfwGetKey((long)window.method_4490(), (int)90) == 1)) {
                CraftingTweaks.isServerSideInstalled = false;
                player.method_7353((class_2561)class_2561.method_43470((String)"[CraftingTweaks] Enabled client-side testing mode"), false);
            }
        }
    }

    public static boolean screenMouseRelease(ScreenMouseEvent event) {
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    public static boolean screenMouseClick(ScreenMouseEvent event) {
        class_437 screen = event.getScreen();
        int button = event.getButton();
        rightClickCraftingSlot = -1;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return false;
        }
        class_1735 mouseSlot = screen instanceof class_465 ? ((AbstractContainerScreenAccessor)screen).getHoveredSlot() : null;
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (grid != null) {
            if (ModKeyMappings.keyTransferStack.isActiveAndDown()) {
                if (mouseSlot != null && mouseSlot.method_7681()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (class_437.method_25442()) {
                        class_1799 mouseSlotStack = mouseSlot.method_7677();
                        for (class_1735 slot : menu.field_7761) {
                            class_1799 slotStack;
                            if (!slot.method_7681() || mouseSlot == slot || !class_1799.method_31577((class_1799)(slotStack = slot.method_7677()), (class_1799)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (class_1735 slot : transferSlots) {
                            Balm.getNetworking().sendToServer((Object)new TransferStackMessage(grid.getId(), slot.field_7874));
                        }
                    } else {
                        for (class_1735 slot : transferSlots) {
                            clientProvider.transferIntoGrid((class_1657)player, menu, grid, slot);
                        }
                        ignoreMouseUp = true;
                    }
                    return true;
                }
            } else if (CraftingTweaksConfig.getActive().client.rightClickCraftsStack && button == 1 && mouseSlot instanceof class_1734) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new CraftStackMessage(mouseSlot.field_7874));
                } else {
                    rightClickCraftingSlot = mouseSlot.field_7874;
                }
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    public static void screenInitialized(ScreenInitEvent event) {
        class_437 screen = event.getScreen();
        if (screen instanceof class_465) {
            unpleasantButton = CraftingGuideButtonFixer.fixMistakes((class_465)screen);
            if (unpleasantButton != null) {
                fixedUnpleasantButtonX = unpleasantButton.method_46426();
            }
        } else {
            unpleasantButton = null;
        }
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            GridGuiHandler guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen);
            List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(((class_465)screen).method_17577());
            for (CraftingGrid grid : grids) {
                String modId = grid.getId().method_12836();
                CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
                if (config != CraftingTweaksMode.DEFAULT && config != CraftingTweaksMode.BUTTONS) continue;
                guiHandler.createButtons(containerScreen, grid, widget -> BalmClient.getScreens().addRenderableWidget(screen, widget));
            }
        }
    }

    private static void handleRightClickCrafting() {
        if (rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = rightClickCraftingSlot;
        rightClickCraftingSlot = -1;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_636 playerController = class_310.method_1551().field_1761;
        if (playerController == null) {
            return;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return;
        }
        if (craftingSlot >= menu.field_7761.size()) {
            return;
        }
        class_1735 mouseSlot = (class_1735)menu.field_7761.get(craftingSlot);
        if (!mouseSlot.method_7681()) {
            rightClickCraftingSlot = mouseSlot.field_7874;
            return;
        }
        class_1799 mouseStack = menu.method_34255();
        if (mouseStack.method_7960() || mouseStack.method_7947() + mouseSlot.method_7677().method_7947() <= mouseStack.method_7914()) {
            playerController.method_2906(menu.field_7763, mouseSlot.field_7874, 0, class_1713.field_7790, (class_1657)player);
            rightClickCraftingSlot = mouseSlot.field_7874;
        }
    }

    public static void screenAboutToDraw(ScreenDrawEvent event) {
        class_437 screen = event.getScreen();
        if (screen == null) {
            return;
        }
        if (screen instanceof class_465) {
            int unpleasantX;
            class_465 containerScreen = (class_465)screen;
            if (unpleasantButton != null && (unpleasantX = unpleasantButton.method_46426()) != fixedUnpleasantButtonX && (unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen)) != null) {
                fixedUnpleasantButtonX = unpleasantButton.method_46426();
            }
        }
    }

    public static void screenDrawn(ScreenDrawEvent event) {
        class_437 screen = event.getScreen();
        if (screen == null) {
            return;
        }
        CraftingTweaksClient.handleRightClickCrafting();
    }

    private static void onItemCrafted(ItemCraftedEvent event) {
        clientProvider.onItemCrafted(event.getCraftMatrix());
    }

    public static ClientProvider getClientProvider() {
        return clientProvider;
    }

    static {
        rightClickCraftingSlot = -1;
    }
}

