/*
 * Decompiled with CFR 0.152.
 */
package git.dragomordor.cobblemizer.fabric.config;

import git.dragomordor.cobblemizer.fabric.config.tierconfigs.EVTierConfig;
import git.dragomordor.cobblemizer.fabric.config.tierconfigs.FriendshipTierConfig;
import git.dragomordor.cobblemizer.fabric.config.tierconfigs.IVTierConfig;
import git.dragomordor.cobblemizer.fabric.config.tierconfigs.LVLTierConfig;
import git.dragomordor.cobblemizer.fabric.misc.TierRarityClass;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CobblemizerConfig {
    private static final String CONFIG_FILE_NAME = "cobblemizer_config.properties";
    private static final Path CONFIG_PATH = Paths.get("config", "cobblemizer", "cobblemizer_config.properties");
    private static List<TierRarityClass> friendshipTiers = new ArrayList<TierRarityClass>();
    private static List<TierRarityClass> EVTiers = new ArrayList<TierRarityClass>();
    private static List<TierRarityClass> IVTiers = new ArrayList<TierRarityClass>();
    private static List<TierRarityClass> LVLTiers = new ArrayList<TierRarityClass>();

    public static void CobblemizerLoadNewConfig() {
        CobblemizerConfig.loadConfig();
    }

    private static void loadConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            CobblemizerConfig.createConfigFile();
        }
        try {
            Properties properties = new Properties();
            properties.load(Files.newBufferedReader(CONFIG_PATH));
            friendshipTiers = CobblemizerConfig.parseTierList(properties.getProperty("FriendshipTiers"));
            EVTiers = CobblemizerConfig.parseTierList(properties.getProperty("EVTiers"));
            IVTiers = CobblemizerConfig.parseTierList(properties.getProperty("IVTiers"));
            LVLTiers = CobblemizerConfig.parseTierList(properties.getProperty("LVLTiers"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createConfigFile() {
        try {
            Properties properties = new Properties();
            properties.setProperty("FriendshipTiers", CobblemizerConfig.convertTierListToString(FriendshipTierConfig.getDefaultConfig().getFriendshipTiers()));
            properties.setProperty("EVTiers", CobblemizerConfig.convertTierListToString(EVTierConfig.getDefaultConfig().getEVTiers()));
            properties.setProperty("IVTiers", CobblemizerConfig.convertTierListToString(IVTierConfig.getDefaultConfig().getIVTiers()));
            properties.setProperty("LVLTiers", CobblemizerConfig.convertTierListToString(LVLTierConfig.getDefaultConfig().getLVLTiers()));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            properties.store(Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]), "Cobblemizer Configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<TierRarityClass> parseTierList(String tiersString) {
        ArrayList<TierRarityClass> parsedTiers = new ArrayList<TierRarityClass>();
        if (tiersString != null && !tiersString.isEmpty()) {
            String[] tierStrings;
            for (String tierStr : tierStrings = tiersString.split(", ")) {
                String[] tierData = tierStr.split(":");
                if (tierData.length != 2) continue;
                String tierName = tierData[0];
                int rarity = Integer.parseInt(tierData[1]);
                parsedTiers.add(new TierRarityClass(tierName, rarity));
            }
        }
        return parsedTiers;
    }

    private static String convertTierListToString(List<TierRarityClass> tiers) {
        StringBuilder tierString = new StringBuilder();
        for (TierRarityClass tier : tiers) {
            tierString.append(tier.getName()).append(":").append(tier.getIncreaseAmount()).append(", ");
        }
        if (tierString.length() > 2) {
            tierString.setLength(tierString.length() - 2);
        }
        return tierString.toString();
    }

    public static List<TierRarityClass> getFriendshipTiers() {
        return friendshipTiers;
    }

    public static List<TierRarityClass> getEVTiers() {
        return EVTiers;
    }

    public static List<TierRarityClass> getIVTiers() {
        return IVTiers;
    }

    public static List<TierRarityClass> getLVLTiers() {
        return LVLTiers;
    }
}

