/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.block;

import abeshutt.staracademy.block.SafariPortalBlock;
import abeshutt.staracademy.init.ModBlocks;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;

public class SafariPortal {
    private static final class_4970.class_4973 IS_VALID_FRAME_BLOCK = (state, world, pos) -> state.method_27852((class_2248)ModBlocks.SAFARI_PORTAL_FRAME.get());
    private final class_1936 world;
    private final class_2350.class_2351 axis;
    private final class_2350 negativeDir;
    private int foundPortalBlocks;
    private class_2338 lowerCorner;
    private int height;
    private final int width;

    public static Optional<SafariPortal> getNewPortal(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        return SafariPortal.getOrEmpty(world, pos, areaHelper -> areaHelper.isValid() && areaHelper.foundPortalBlocks == 0, axis);
    }

    public static Optional<SafariPortal> getOrEmpty(class_1936 world, class_2338 pos, Predicate<SafariPortal> validator, class_2350.class_2351 axis) {
        Optional<SafariPortal> optional = Optional.of(new SafariPortal(world, pos, axis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new SafariPortal(world, pos, axis2)).filter(validator);
    }

    public SafariPortal(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        this.world = world;
        this.axis = axis;
        this.negativeDir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        this.lowerCorner = this.getLowerCorner(pos);
        if (this.lowerCorner == null) {
            this.lowerCorner = pos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.getWidth();
            if (this.width > 0) {
                this.height = this.getHeight();
            }
        }
    }

    @Nullable
    private class_2338 getLowerCorner(class_2338 pos) {
        int i = Math.max(this.world.method_31607(), pos.method_10264() - 21);
        while (pos.method_10264() > i && SafariPortal.validStateInsidePortal(this.world.method_8320(pos.method_10074()))) {
            pos = pos.method_10074();
        }
        class_2350 direction = this.negativeDir.method_10153();
        int j = this.getWidth(pos, direction) - 1;
        return j < 0 ? null : pos.method_10079(direction, j);
    }

    private int getWidth() {
        int i = this.getWidth(this.lowerCorner, this.negativeDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getWidth(class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            mutable.method_10101((class_2382)pos).method_10104(direction, i);
            class_2680 blockState = this.world.method_8320((class_2338)mutable);
            if (!SafariPortal.validStateInsidePortal(blockState)) {
                if (!IS_VALID_FRAME_BLOCK.test(blockState, (class_1922)this.world, (class_2338)mutable)) break;
                return i;
            }
            class_2680 blockState2 = this.world.method_8320((class_2338)mutable.method_10098(class_2350.field_11033));
            if (!IS_VALID_FRAME_BLOCK.test(blockState2, (class_1922)this.world, (class_2338)mutable)) break;
        }
        return 0;
    }

    private int getHeight() {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int i = this.getPotentialHeight(mutable);
        return i >= 3 && i <= 21 && this.isHorizontalFrameValid(mutable, i) ? i : 0;
    }

    private boolean isHorizontalFrameValid(class_2338.class_2339 pos, int height) {
        for (int i = 0; i < this.width; ++i) {
            class_2338.class_2339 mutable = pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, height).method_10104(this.negativeDir, i);
            if (IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)mutable), (class_1922)this.world, (class_2338)mutable)) continue;
            return false;
        }
        return true;
    }

    private int getPotentialHeight(class_2338.class_2339 pos) {
        for (int i = 0; i < 21; ++i) {
            pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, -1);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)pos), (class_1922)this.world, (class_2338)pos)) {
                return i;
            }
            pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, this.width);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)pos), (class_1922)this.world, (class_2338)pos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, j);
                class_2680 blockState = this.world.method_8320((class_2338)pos);
                if (!SafariPortal.validStateInsidePortal(blockState)) {
                    return i;
                }
                if (!blockState.method_27852((class_2248)ModBlocks.SAFARI_PORTAL.get())) continue;
                ++this.foundPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean validStateInsidePortal(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_27852((class_2248)ModBlocks.SAFARI_PORTAL.get());
    }

    public boolean isValid() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortal() {
        class_2680 blockState = (class_2680)((SafariPortalBlock)((Object)ModBlocks.SAFARI_PORTAL.get())).method_9564().method_11657(SafariPortalBlock.AXIS, (Comparable)this.axis);
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.negativeDir, this.width - 1)).forEach(blockPos -> this.world.method_8652(blockPos, blockState, 18));
    }

    public boolean wasAlreadyValid() {
        return this.isValid() && this.foundPortalBlocks == this.width * this.height;
    }

    public static class_243 entityPosInPortal(class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 entityPos, class_4048 entityDimensions) {
        double h;
        class_2350.class_2351 axis;
        double g;
        double d = (double)portalRect.field_25937 - (double)entityDimensions.field_18067;
        double e = (double)portalRect.field_25938 - (double)entityDimensions.field_18068;
        class_2338 blockPos = portalRect.field_25936;
        if (d > 0.0) {
            float f = (float)blockPos.method_30558(portalAxis) + entityDimensions.field_18067 / 2.0f;
            g = class_3532.method_15350((double)class_3532.method_15370((double)(entityPos.method_18043(portalAxis) - (double)f), (double)0.0, (double)d), (double)0.0, (double)1.0);
        } else {
            g = 0.5;
        }
        if (e > 0.0) {
            axis = class_2350.class_2351.field_11052;
            h = class_3532.method_15350((double)class_3532.method_15370((double)(entityPos.method_18043(axis) - (double)blockPos.method_30558(axis)), (double)0.0, (double)e), (double)0.0, (double)1.0);
        } else {
            h = 0.0;
        }
        axis = portalAxis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        double i = entityPos.method_18043(axis) - ((double)blockPos.method_30558(axis) + 0.5);
        return new class_243(g, h, i);
    }

    public static class_5454 getNetherTeleportTarget(class_3218 destination, class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 offset, class_1297 entity, class_243 velocity, float yaw, float pitch) {
        class_2338 blockPos = portalRect.field_25936;
        class_2680 blockState = destination.method_8320(blockPos);
        class_2350.class_2351 axis = blockState.method_28500((class_2769)class_2741.field_12529).orElse(class_2350.class_2351.field_11048);
        double d = portalRect.field_25937;
        double e = portalRect.field_25938;
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        int i = portalAxis == axis ? 0 : 90;
        class_243 vec3d = portalAxis == axis ? velocity : new class_243(velocity.field_1350, velocity.field_1351, -velocity.field_1352);
        double f = (double)entityDimensions.field_18067 / 2.0 + (d - (double)entityDimensions.field_18067) * offset.method_10216();
        double g = (e - (double)entityDimensions.field_18068) * offset.method_10214();
        double h = 0.5 + offset.method_10215();
        boolean bl = axis == class_2350.class_2351.field_11048;
        class_243 vec3d2 = new class_243((double)blockPos.method_10263() + (bl ? f : h), (double)blockPos.method_10264() + g, (double)blockPos.method_10260() + (bl ? h : f));
        class_243 vec3d3 = SafariPortal.findOpenPosition(vec3d2, destination, entity, entityDimensions);
        return new class_5454(vec3d3, vec3d, yaw + (float)i, pitch);
    }

    private static class_243 findOpenPosition(class_243 fallback, class_3218 world, class_1297 entity, class_4048 dimensions) {
        if (!(dimensions.field_18067 > 4.0f) && !(dimensions.field_18068 > 4.0f)) {
            double d = (double)dimensions.field_18068 / 2.0;
            class_243 vec3d = fallback.method_1031(0.0, d, 0.0);
            class_265 voxelShape = class_259.method_1078((class_238)class_238.method_30048((class_243)vec3d, (double)dimensions.field_18067, (double)0.0, (double)dimensions.field_18067).method_1012(0.0, 1.0, 0.0).method_1014(1.0E-6));
            Optional optional = world.method_33594(entity, voxelShape, vec3d, (double)dimensions.field_18067, (double)dimensions.field_18068, (double)dimensions.field_18067);
            Optional<class_243> optional2 = optional.map(pos -> pos.method_1023(0.0, d, 0.0));
            return optional2.orElse(fallback);
        }
        return fallback;
    }
}

