/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.block.entity;

import abeshutt.staracademy.init.ModBlocks;
import abeshutt.staracademy.screen.BetterStructureBlockScreen;
import abeshutt.staracademy.util.ProxyStructureTemplate;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2515;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3488;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BetterStructureBlockEntity
extends class_2586 {
    private class_2960 templateName;
    private String author = "";
    private String metadata = "";
    private class_2338 offset = new class_2338(0, 1, 0);
    private class_2382 size = class_2382.field_11176;
    private class_2415 mirror = class_2415.field_11302;
    private class_2470 rotation = class_2470.field_11467;
    private class_2776 mode;
    private boolean ignoreEntities = true;
    private boolean powered;
    private boolean showAir;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed;

    public BetterStructureBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlocks.Entities.STRUCTURE_BLOCK.get(), pos, state);
        this.mode = (class_2776)state.method_11654((class_2769)class_2515.field_11586);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("name", this.getTemplateName());
        nbt.method_10582("author", this.author);
        nbt.method_10582("metadata", this.metadata);
        nbt.method_10569("posX", this.offset.method_10263());
        nbt.method_10569("posY", this.offset.method_10264());
        nbt.method_10569("posZ", this.offset.method_10260());
        nbt.method_10569("sizeX", this.size.method_10263());
        nbt.method_10569("sizeY", this.size.method_10264());
        nbt.method_10569("sizeZ", this.size.method_10260());
        nbt.method_10582("rotation", this.rotation.toString());
        nbt.method_10582("mirror", this.mirror.toString());
        nbt.method_10582("mode", this.mode.toString());
        nbt.method_10556("ignoreEntities", this.ignoreEntities);
        nbt.method_10556("powered", this.powered);
        nbt.method_10556("showair", this.showAir);
        nbt.method_10556("showboundingbox", this.showBoundingBox);
        nbt.method_10548("integrity", this.integrity);
        nbt.method_10544("seed", this.seed);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setTemplateName(nbt.method_10558("name"));
        this.author = nbt.method_10558("author");
        this.metadata = nbt.method_10558("metadata");
        int i = nbt.method_10550("posX");
        int j = nbt.method_10550("posY");
        int k = nbt.method_10550("posZ");
        this.offset = new class_2338(i, j, k);
        int l = nbt.method_10550("sizeX");
        int m = nbt.method_10550("sizeY");
        int n = nbt.method_10550("sizeZ");
        this.size = new class_2382(l, m, n);
        try {
            this.rotation = class_2470.valueOf((String)nbt.method_10558("rotation"));
        }
        catch (IllegalArgumentException var11) {
            this.rotation = class_2470.field_11467;
        }
        try {
            this.mirror = class_2415.valueOf((String)nbt.method_10558("mirror"));
        }
        catch (IllegalArgumentException var10) {
            this.mirror = class_2415.field_11302;
        }
        try {
            this.mode = class_2776.valueOf((String)nbt.method_10558("mode"));
        }
        catch (IllegalArgumentException var9) {
            this.mode = class_2776.field_12696;
        }
        this.ignoreEntities = nbt.method_10577("ignoreEntities");
        this.powered = nbt.method_10577("powered");
        this.showAir = nbt.method_10577("showair");
        this.showBoundingBox = nbt.method_10577("showboundingbox");
        this.integrity = nbt.method_10545("integrity") ? nbt.method_10583("integrity") : 1.0f;
        this.seed = nbt.method_10537("seed");
        this.updateBlockMode();
    }

    private void updateBlockMode() {
        class_2338 blockPos;
        class_2680 blockState;
        if (this.field_11863 != null && (blockState = this.field_11863.method_8320(blockPos = this.method_11016())).method_27852(class_2246.field_10465)) {
            this.field_11863.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2515.field_11586, (Comparable)this.mode), 2);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean openScreen() {
        class_310.method_1551().method_1507((class_437)new BetterStructureBlockScreen(this));
        return true;
    }

    public String getTemplateName() {
        return this.templateName == null ? "" : this.templateName.toString();
    }

    public String getStructurePath() {
        return this.templateName == null ? "" : this.templateName.method_12832();
    }

    public boolean hasStructureName() {
        return this.templateName != null;
    }

    public void setTemplateName(@Nullable String templateName) {
        this.setTemplateName(class_3544.method_15438((String)templateName) ? null : class_2960.method_12829((String)templateName));
    }

    public void setTemplateName(@Nullable class_2960 templateName) {
        this.templateName = templateName;
    }

    public void setAuthor(class_1309 entity) {
        this.author = entity.method_5477().getString();
    }

    public class_2338 getOffset() {
        return this.offset;
    }

    public void setOffset(class_2338 offset) {
        this.offset = offset;
    }

    public class_2382 getSize() {
        return this.size;
    }

    public void setSize(class_2382 size) {
        this.size = size;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public void setMirror(class_2415 mirror) {
        this.mirror = mirror;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public void setRotation(class_2470 rotation) {
        this.rotation = rotation;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public class_2776 getMode() {
        return this.mode;
    }

    public void setMode(class_2776 mode) {
        this.mode = mode;
        class_2680 blockState = this.field_11863.method_8320(this.method_11016());
        if (blockState.method_27852(class_2246.field_10465)) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)blockState.method_11657((class_2769)class_2515.field_11586, (Comparable)mode), 2);
        }
    }

    public boolean shouldIgnoreEntities() {
        return this.ignoreEntities;
    }

    public void setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float integrity) {
        this.integrity = integrity;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean detectStructureSize() {
        if (this.mode != class_2776.field_12695) {
            return false;
        }
        class_2338 blockPos = this.method_11016();
        class_2338 blockPos2 = new class_2338(blockPos.method_10263() - 80, this.field_11863.method_31607(), blockPos.method_10260() - 80);
        class_2338 blockPos3 = new class_2338(blockPos.method_10263() + 80, this.field_11863.method_31600() - 1, blockPos.method_10260() + 80);
        Stream<class_2338> stream = this.streamCornerPos(blockPos2, blockPos3);
        return BetterStructureBlockEntity.getStructureBox(blockPos, stream).filter(box -> {
            int i = box.method_35418() - box.method_35415();
            int j = box.method_35419() - box.method_35416();
            int k = box.method_35420() - box.method_35417();
            if (i > 1 && j > 1 && k > 1) {
                this.offset = new class_2338(box.method_35415() - blockPos.method_10263() + 1, box.method_35416() - blockPos.method_10264() + 1, box.method_35417() - blockPos.method_10260() + 1);
                this.size = new class_2382(i - 1, j - 1, k - 1);
                this.method_5431();
                class_2680 blockState = this.field_11863.method_8320(blockPos);
                this.field_11863.method_8413(blockPos, blockState, blockState, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<class_2338> streamCornerPos(class_2338 start, class_2338 end) {
        return class_2338.method_20437((class_2338)start, (class_2338)end).filter(pos -> this.field_11863.method_8320(pos).method_27852(class_2246.field_10465)).map(arg_0 -> ((class_1937)this.field_11863).method_8321(arg_0)).filter(blockEntity -> blockEntity instanceof BetterStructureBlockEntity).map(blockEntity -> (BetterStructureBlockEntity)((Object)blockEntity)).filter(blockEntity -> blockEntity.mode == class_2776.field_12699 && Objects.equals(this.templateName, blockEntity.templateName)).map(class_2586::method_11016);
    }

    private static Optional<class_3341> getStructureBox(class_2338 pos, Stream<class_2338> corners) {
        Iterator iterator = corners.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        class_2338 blockPos = (class_2338)iterator.next();
        class_3341 blockBox = new class_3341(blockPos);
        if (iterator.hasNext()) {
            Objects.requireNonNull(blockBox);
            iterator.forEachRemaining(arg_0 -> ((class_3341)blockBox).method_34389(arg_0));
        } else {
            blockBox.method_34389(pos);
        }
        return Optional.of(blockBox);
    }

    public boolean saveStructure() {
        return this.saveStructure(true);
    }

    public boolean saveStructure(boolean interactive) {
        if (this.mode == class_2776.field_12695 && !this.field_11863.field_9236 && this.templateName != null) {
            class_3499 structure;
            class_2338 pos = this.method_11016().method_10081((class_2382)this.offset);
            class_3218 serverWorld = (class_3218)this.field_11863;
            class_3485 structureTemplateManager = serverWorld.method_14183();
            try {
                structure = structureTemplateManager.method_15091(this.templateName);
            }
            catch (class_151 var8) {
                return false;
            }
            ProxyStructureTemplate.of(structure).ifPresent(proxy -> proxy.setCustom(true));
            structure.method_15174(this.field_11863, pos, this.size, !this.ignoreEntities, null);
            structure.method_15161(this.author);
            if (interactive) {
                try {
                    return structureTemplateManager.method_15093(this.templateName);
                }
                catch (class_151 var7) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean loadStructure(class_3218 world) {
        return this.loadStructure(world, true);
    }

    public static class_5819 createRandom(long seed) {
        return seed == 0L ? class_5819.method_43049((long)class_156.method_658()) : class_5819.method_43049((long)seed);
    }

    public boolean loadStructure(class_3218 world, boolean interactive) {
        if (this.mode == class_2776.field_12697 && this.templateName != null) {
            Optional optional;
            class_3485 structureTemplateManager = world.method_14183();
            try {
                optional = structureTemplateManager.method_15094(this.templateName);
            }
            catch (class_151 var6) {
                return false;
            }
            return optional.filter(t -> this.place(world, interactive, (class_3499)t)).isPresent();
        }
        return false;
    }

    public boolean place(class_3218 world, boolean interactive, class_3499 template) {
        class_2382 vec3i;
        boolean bl;
        class_2338 blockPos = this.method_11016();
        if (!class_3544.method_15438((String)template.method_15181())) {
            this.author = template.method_15181();
        }
        if (!(bl = this.size.equals((Object)(vec3i = template.method_15160())))) {
            this.size = vec3i;
            this.method_5431();
            class_2680 blockState = world.method_8320(blockPos);
            world.method_8413(blockPos, blockState, blockState, 3);
        }
        if (interactive && !bl) {
            return false;
        }
        class_3492 structurePlacementData = new class_3492().method_15125(this.mirror).method_15123(this.rotation).method_15133(this.ignoreEntities);
        if (this.integrity < 1.0f) {
            structurePlacementData.method_16183().method_16184((class_3491)new class_3488(class_3532.method_15363((float)this.integrity, (float)0.0f, (float)1.0f))).method_15112(BetterStructureBlockEntity.createRandom(this.seed));
        }
        class_2338 blockPos2 = blockPos.method_10081((class_2382)this.offset);
        template.method_15172((class_5425)world, blockPos2, blockPos2, structurePlacementData, BetterStructureBlockEntity.createRandom(this.seed), 2);
        return true;
    }

    public void unloadStructure() {
        if (this.templateName != null) {
            class_3218 serverWorld = (class_3218)this.field_11863;
            class_3485 structureTemplateManager = serverWorld.method_14183();
            structureTemplateManager.method_15087(this.templateName);
        }
    }

    public boolean isStructureAvailable() {
        if (this.mode == class_2776.field_12697 && !this.field_11863.field_9236 && this.templateName != null) {
            class_3218 serverWorld = (class_3218)this.field_11863;
            class_3485 structureTemplateManager = serverWorld.method_14183();
            try {
                return structureTemplateManager.method_15094(this.templateName).isPresent();
            }
            catch (class_151 var4) {
                return false;
            }
        }
        return false;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    public boolean shouldShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean showAir) {
        this.showAir = showAir;
    }

    public boolean shouldShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean showBoundingBox) {
        this.showBoundingBox = showBoundingBox;
    }

    public static enum Action {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

