/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.biome.BiomePredicate;
import abeshutt.staracademy.data.entity.EntityPredicate;
import abeshutt.staracademy.data.item.ItemPredicate;
import abeshutt.staracademy.data.tile.TilePredicate;
import abeshutt.staracademy.util.ItemUseLogic;
import abeshutt.staracademy.world.roll.IntRoll;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public abstract class Config {
    protected static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().setLenient().registerTypeHierarchyAdapter(TilePredicate.class, (Object)Adapters.TILE_PREDICATE).registerTypeHierarchyAdapter(EntityPredicate.class, (Object)Adapters.ENTITY_PREDICATE).registerTypeHierarchyAdapter(ItemPredicate.class, (Object)Adapters.ITEM_PREDICATE).registerTypeHierarchyAdapter(BiomePredicate.class, (Object)Adapters.BIOME_PREDICATE).registerTypeHierarchyAdapter(IntRoll.class, (Object)Adapters.INT_ROLL).registerTypeAdapter(class_2338.class, (Object)Adapters.BLOCK_POS).registerTypeAdapter(class_2960.class, (Object)Adapters.IDENTIFIER).registerTypeAdapter(class_1799.class, (Object)Adapters.ITEM_STACK).registerTypeAdapter(PokemonProperties.class, (Object)Adapters.POKEMON_PROPERTIES).registerTypeAdapter(ItemUseLogic.class, Adapters.of(ItemUseLogic::new, false)).create();

    public abstract void write() throws IOException;

    public abstract <C extends Config> C read() throws IOException;

    protected abstract void reset();

    protected final void writeFile(Path path, Object file) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        FileWriter writer = new FileWriter(path.toFile());
        GSON.toJson(file, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    protected final <C> C readFile(Path path, Type type) throws FileNotFoundException {
        return (C)GSON.fromJson((Reader)new FileReader(path.toFile()), type);
    }
}

