/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.nbt;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.nbt.NbtAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;

public class CompoundNbtAdapter
extends NbtAdapter<class_2487> {
    public CompoundNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public CompoundNbtAdapter asNullable() {
        return new CompoundNbtAdapter(true);
    }

    @Override
    protected void writeTagBits(class_2487 value, BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(value.method_10546(), buffer);
        for (String key : value.method_10541()) {
            Adapters.UTF_8.writeBits(key, buffer);
            Adapters.GENERIC_NBT.writeBits(value.method_10580(key), buffer);
        }
    }

    @Override
    protected class_2487 readTagBits(BitBuffer buffer) {
        class_2487 compound = new class_2487();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readBits(buffer).orElseThrow();
            class_2520 tag = (class_2520)Adapters.GENERIC_NBT.readBits(buffer).orElseThrow();
            compound.method_10566(key, tag);
        }
        return compound;
    }

    @Override
    protected void writeTagBytes(class_2487 value, ByteBuf buffer) {
        Adapters.INT_SEGMENTED_3.writeBytes(value.method_10546(), buffer);
        for (String key : value.method_10541()) {
            Adapters.UTF_8.writeBytes(key, buffer);
            Adapters.GENERIC_NBT.writeBytes(value.method_10580(key), buffer);
        }
    }

    @Override
    protected class_2487 readTagBytes(ByteBuf buffer) {
        class_2487 compound = new class_2487();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readBytes(buffer).orElseThrow();
            class_2520 tag = (class_2520)Adapters.GENERIC_NBT.readBytes(buffer).orElseThrow();
            compound.method_10566(key, tag);
        }
        return compound;
    }

    @Override
    protected void writeTagData(class_2487 value, DataOutput data) throws IOException {
        Adapters.INT_SEGMENTED_3.writeData(value.method_10546(), data);
        for (String key : value.method_10541()) {
            Adapters.UTF_8.writeData(key, data);
            Adapters.GENERIC_NBT.writeData(value.method_10580(key), data);
        }
    }

    @Override
    protected class_2487 readTagData(DataInput data) throws IOException {
        class_2487 compound = new class_2487();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readData(data).orElseThrow();
            class_2520 tag = (class_2520)Adapters.GENERIC_NBT.readData(data).orElseThrow();
            compound.method_10566(key, tag);
        }
        return compound;
    }

    @Override
    protected class_2520 writeTagNbt(class_2487 value) {
        return value.method_10553();
    }

    @Override
    protected class_2487 readTagNbt(class_2520 nbt) {
        class_2487 class_24872;
        if (nbt instanceof class_2487) {
            class_2487 tag = (class_2487)nbt;
            class_24872 = tag.method_10553();
        } else {
            class_24872 = null;
        }
        return class_24872;
    }

    @Override
    protected JsonElement writeTagJson(class_2487 value) {
        return new JsonPrimitive(value.method_10714());
    }

    @Override
    protected class_2487 readTagJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            try {
                return class_2522.method_10718((String)primitive.getAsString());
            }
            catch (CommandSyntaxException exception) {
                return null;
            }
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            class_2487 nbt = new class_2487();
            for (String key : object.keySet()) {
                JsonElement element = object.get(key);
                Adapters.GENERIC_NBT.readJson(element).ifPresent(tag -> nbt.method_10566(key, tag));
            }
            return nbt;
        }
        return null;
    }
}

