/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.number;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.number.NumberAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class BigDecimalAdapter
extends NumberAdapter<BigDecimal> {
    public BigDecimalAdapter(boolean nullable) {
        super(nullable);
    }

    public BigDecimalAdapter asNullable() {
        return new BigDecimalAdapter(true);
    }

    @Override
    protected void writeNumberBits(BigDecimal value, BitBuffer buffer) {
        Adapters.BIG_INTEGER.writeBits(value.unscaledValue(), buffer);
        Adapters.INT.writeBits(value.scale(), buffer);
    }

    @Override
    protected BigDecimal readNumberBits(BitBuffer buffer) {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readBits(buffer).orElseThrow(), (Integer)Adapters.INT.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberBytes(BigDecimal value, ByteBuf buffer) {
        Adapters.BIG_INTEGER.writeBytes(value.unscaledValue(), buffer);
        Adapters.INT.writeBytes(value.scale(), buffer);
    }

    @Override
    protected BigDecimal readNumberBytes(ByteBuf buffer) {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readBytes(buffer).orElseThrow(), (Integer)Adapters.INT.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberData(BigDecimal value, DataOutput data) throws IOException {
        Adapters.BIG_INTEGER.writeData(value.unscaledValue(), data);
        Adapters.INT.writeData(value.scale(), data);
    }

    @Override
    protected BigDecimal readNumberData(DataInput data) throws IOException {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readData(data).orElseThrow(), (Integer)Adapters.INT.readData(data).orElseThrow());
    }

    @Override
    protected class_2520 writeNumberNbt(BigDecimal value) {
        return BigDecimalAdapter.wrap(BigDecimalAdapter.reduce(value));
    }

    @Override
    protected BigDecimal readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return BigDecimal.valueOf(numeric.method_10699());
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return BigDecimalAdapter.parse(string.method_10714()).map(number -> {
                BigDecimal value;
                return number instanceof BigDecimal ? (value = (BigDecimal)number) : BigDecimal.valueOf(number.doubleValue());
            }).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(BigDecimal value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    protected BigDecimal readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsBigDecimal();
            }
            if (primitive.isString()) {
                return BigDecimalAdapter.parse(primitive.getAsString()).map(number -> {
                    BigDecimal value;
                    return number instanceof BigDecimal ? (value = (BigDecimal)number) : BigDecimal.valueOf(number.doubleValue());
                }).orElse(null);
            }
        }
        return null;
    }
}

