/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.biome;

import abeshutt.staracademy.data.biome.BiomePlacement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class PartialBiomeTag
implements BiomePlacement<PartialBiomeTag> {
    private class_2960 id;

    public PartialBiomeTag(class_2960 id) {
        this.id = id;
    }

    public static PartialBiomeTag of(class_2960 id) {
        return new PartialBiomeTag(id);
    }

    @Override
    public boolean isSubsetOf(PartialBiomeTag other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillInto(PartialBiomeTag other) {
        if (this.id != null) {
            other.id = this.id;
        }
    }

    @Override
    public boolean test(class_6880<class_1959> biome) {
        return biome.method_40228().anyMatch(tag -> tag.comp_327().equals((Object)this.id));
    }

    @Override
    public PartialBiomeTag copy() {
        return new PartialBiomeTag(this.id);
    }

    public String toString() {
        return this.id != null ? "#" + String.valueOf(this.id) : "";
    }

    public static Optional<PartialBiomeTag> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBiomeTag.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBiomeTag parse(String string) throws CommandSyntaxException {
        return PartialBiomeTag.parse(new StringReader(string));
    }

    public static PartialBiomeTag parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '#') {
            throw new IllegalArgumentException("Invalid block tag '" + reader.getString() + "' does not start with #");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBiomeTag.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBiomeTag.of(new class_2960(string));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid tag identifier '" + string + "' in biome tag '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

