/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.entity;

import abeshutt.staracademy.data.entity.EntityPlacement;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class PartialEntity
implements EntityPlacement<PartialEntity> {
    private class_243 pos;
    private class_2338 blockPos;
    private PartialCompoundNbt nbt;

    protected PartialEntity(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        this.pos = pos;
        this.blockPos = blockPos;
        this.nbt = nbt;
    }

    public static PartialEntity of(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        return new PartialEntity(pos, blockPos, nbt);
    }

    public static PartialEntity of(class_243 pos, class_2338 blockPos, class_2960 id, PartialCompoundNbt nbt) {
        if (id != null) {
            class_2487 tag = nbt.asWhole().orElse(new class_2487());
            tag.method_10582("id", id.toString());
            return new PartialEntity(pos, blockPos, PartialCompoundNbt.of(tag));
        }
        return new PartialEntity(pos, blockPos, nbt);
    }

    public static PartialEntity of(class_1297 entity) {
        return new PartialEntity(entity.method_19538(), entity.method_24515(), PartialCompoundNbt.of(entity));
    }

    public class_243 getPos() {
        return this.pos;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public void setPos(class_243 pos) {
        this.pos = pos;
    }

    public void setBlockPos(class_2338 blockPos) {
        this.blockPos = blockPos;
    }

    public void setNbt(PartialCompoundNbt nbt) {
        this.nbt = nbt;
    }

    @Override
    public boolean isSubsetOf(PartialEntity other) {
        return this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1297 entity) {
        return this.isSubsetOf(PartialEntity.of(entity));
    }

    @Override
    public void fillInto(PartialEntity other) {
        if (this.pos != null) {
            other.pos = this.pos;
        }
        if (this.blockPos != null) {
            other.blockPos = this.blockPos.method_10062();
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public void place(class_1945 world) {
    }

    @Override
    public boolean test(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        return this.nbt.isSubsetOf(nbt);
    }

    @Override
    public PartialEntity copy() {
        return new PartialEntity(this.pos, this.blockPos.method_10062(), this.nbt.copy());
    }

    public String toString() {
        return this.nbt.toString();
    }

    public static Optional<PartialEntity> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialEntity.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialEntity parse(String string) throws CommandSyntaxException {
        return PartialEntity.parse(new StringReader(string));
    }

    public static PartialEntity parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialEntity.isCharValid(reader.peek())) {
            return PartialEntity.of(null, null, null, PartialCompoundNbt.parse(reader));
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialEntity.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialEntity.of(null, null, string.isEmpty() ? null : new class_2960(string), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid entity identifier '" + string + "' in entity '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

