/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.nbt;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.entity.EntityPlacement;
import abeshutt.staracademy.data.item.ItemPlacement;
import abeshutt.staracademy.data.item.PartialItem;
import abeshutt.staracademy.data.nbt.PartialListNbt;
import abeshutt.staracademy.data.tile.PartialBlockState;
import abeshutt.staracademy.data.tile.TilePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2586;

public class PartialCompoundNbt
implements TilePlacement<PartialCompoundNbt>,
EntityPlacement<PartialCompoundNbt>,
ItemPlacement<PartialCompoundNbt> {
    private class_2487 nbt;

    protected PartialCompoundNbt(class_2487 nbt) {
        this.nbt = nbt;
    }

    public static PartialCompoundNbt empty() {
        return new PartialCompoundNbt(new class_2487());
    }

    public static PartialCompoundNbt of(class_2487 nbt) {
        return new PartialCompoundNbt(nbt);
    }

    public static PartialCompoundNbt of(class_1297 entity) {
        if (entity == null) {
            return new PartialCompoundNbt(null);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", class_1299.method_5890((class_1299)entity.method_5864()).toString());
        return new PartialCompoundNbt(entity.method_5647(nbt));
    }

    public static PartialCompoundNbt of(class_2586 blockEntity) {
        if (blockEntity == null) {
            return new PartialCompoundNbt(null);
        }
        return new PartialCompoundNbt(blockEntity.method_38243());
    }

    public static PartialCompoundNbt at(class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return new PartialCompoundNbt(null);
        }
        return new PartialCompoundNbt(blockEntity.method_38243());
    }

    public static PartialCompoundNbt of(class_1799 stack) {
        return new PartialCompoundNbt(stack.method_7969());
    }

    @Override
    public boolean isSubsetOf(PartialCompoundNbt other) {
        if (this.nbt == null) {
            return true;
        }
        if (other.nbt == null || this.nbt.method_10546() > other.nbt.method_10546()) {
            return false;
        }
        for (String key : this.nbt.method_10541()) {
            class_2520 nbt1 = this.nbt.method_10580(key);
            class_2520 nbt2 = other.nbt.method_10580(key);
            if (nbt1 == null) continue;
            if (nbt2 == null || nbt1.method_10711() != nbt2.method_10711()) {
                return false;
            }
            if (!(nbt1.method_10711() == 10 ? !PartialCompoundNbt.of((class_2487)nbt1).isSubsetOf(PartialCompoundNbt.of((class_2487)nbt2)) : (nbt1 instanceof class_2483 ? !PartialListNbt.of((class_2483)nbt1).isSubsetOf(PartialListNbt.of((class_2483)nbt2)) : !nbt1.equals(nbt2)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        if (this.nbt == null) {
            return true;
        }
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity != null && this.isSubsetOf(PartialCompoundNbt.of(blockEntity.method_38243()));
    }

    @Override
    public boolean isSubsetOf(class_1297 entity) {
        return this.isSubsetOf(PartialCompoundNbt.of(entity));
    }

    @Override
    public boolean isSubsetOf(class_1799 stack) {
        return this.isSubsetOf(PartialCompoundNbt.of(stack));
    }

    @Override
    public void fillInto(PartialCompoundNbt other) {
        if (this.nbt == null) {
            return;
        }
        if (other.nbt == null) {
            other.nbt = new class_2487();
        }
        for (String key : this.nbt.method_10541()) {
            class_2520 e = this.nbt.method_10580(key);
            if (e == null) continue;
            if ((e = e.method_10707()).method_10711() == 10) {
                if (!other.nbt.method_10545(key)) {
                    other.nbt.method_10566(key, e);
                    continue;
                }
                PartialCompoundNbt.of((class_2487)e).fillInto(PartialCompoundNbt.of(other.nbt.method_10562(key)));
                continue;
            }
            other.nbt.method_10566(key, e);
        }
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        if (this.nbt == null) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        blockEntity.method_11014(this.nbt);
    }

    @Override
    public void place(class_1945 world) {
    }

    @Override
    public Optional<class_1799> generate(int count) {
        return Optional.empty();
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    @Override
    public boolean test(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    public Optional<class_2487> asWhole() {
        return Optional.ofNullable(this.nbt);
    }

    @Override
    public PartialCompoundNbt copy() {
        return new PartialCompoundNbt(this.nbt == null ? null : this.nbt.method_10553());
    }

    public String toString() {
        return this.nbt == null ? "" : this.nbt.toString();
    }

    public static Optional<PartialCompoundNbt> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialCompoundNbt.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialCompoundNbt parse(String string) throws CommandSyntaxException {
        return PartialCompoundNbt.parse(new StringReader(string));
    }

    public static PartialCompoundNbt parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            String string = reader.getString().substring(reader.getCursor());
            int index = string.lastIndexOf(125);
            if (index < 0) {
                throw new IllegalArgumentException("Unclosed nbt in tile '" + reader.getString() + "'");
            }
            return PartialCompoundNbt.of(new class_2522(new StringReader(string.substring(0, index + 1))).method_10727());
        }
        return PartialCompoundNbt.of((class_2487)null);
    }

    public static class Adapter
    implements ISimpleAdapter<PartialCompoundNbt, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialCompoundNbt value) {
            return value == null ? Optional.empty() : Adapters.COMPOUND_NBT.writeNbt(value.nbt);
        }

        @Override
        public Optional<PartialCompoundNbt> readNbt(class_2520 nbt) {
            return nbt == null ? Optional.empty() : Adapters.COMPOUND_NBT.readNbt(nbt).map(PartialCompoundNbt::of);
        }
    }
}

