/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModOutfits;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.item.OutfitEntry;
import abeshutt.staracademy.item.renderer.OutfitItemRenderer;
import abeshutt.staracademy.item.renderer.SpecialItemRenderer;
import abeshutt.staracademy.outfit.core.OutfitPiece;
import abeshutt.staracademy.util.ISpecialItemModel;
import abeshutt.staracademy.world.data.WardrobeData;
import abeshutt.staracademy.world.random.JavaRandom;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1091;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class OutfitItem
extends class_1792
implements ISpecialItemModel {
    public OutfitItem() {
        super(new class_1792.class_1793());
    }

    public static Optional<OutfitEntry> getEntry(class_1799 stack) {
        if (stack.method_7969() != null) {
            return Adapters.OUTFIT_ENTRY.readNbt((class_2520)stack.method_7969().method_10562("entry"));
        }
        return Optional.empty();
    }

    public class_2561 method_7864(class_1799 stack) {
        return OutfitItem.getEntry(stack).flatMap(entry -> {
            if (entry.getNameKey() == null) {
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43471((String)(this.method_7866(stack) + "." + entry.getNameKey())));
        }).orElseGet(() -> super.method_7864(stack));
    }

    public static void setEntry(class_1799 stack, OutfitEntry entry) {
        Adapters.OUTFIT_ENTRY.writeNbt(entry).ifPresent(tag -> stack.method_7948().method_10566("entry", tag));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608() && user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            WardrobeData data = ModWorldData.WARDROBE.getGlobal(world);
            OutfitItem.getEntry(stack).ifPresent(entry -> entry.generate().forEach(outfit -> {
                if (data.setUnlocked(player, (String)outfit, true) && !user.method_7337()) {
                    stack.method_7934(1);
                }
            }));
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        OutfitItem.getEntry(stack).ifPresent(entry -> entry.flatten(JavaRandom.ofNanoTime()).ifPresent(flattened -> {
            if (entry != flattened) {
                OutfitItem.setEntry(stack, entry);
            }
        }));
    }

    @Override
    public void loadModels(Consumer<class_1091> consumer) {
        for (OutfitPiece outfit : ModOutfits.REGISTRY.values()) {
            consumer.accept(outfit.getTexture().getIcon());
        }
    }

    @Override
    public SpecialItemRenderer getRenderer() {
        return OutfitItemRenderer.INSTANCE;
    }
}

