/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.net;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.net.ModPacket;
import abeshutt.staracademy.world.data.StarBadgeData;
import abeshutt.staracademy.world.inventory.BaseInventory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_634;

public class UpdateStarBadgeS2CPacket
extends ModPacket<class_634> {
    private Map<UUID, BaseInventory> inventories;

    public UpdateStarBadgeS2CPacket() {
    }

    public UpdateStarBadgeS2CPacket(Map<UUID, BaseInventory> profiles) {
        this.inventories = profiles;
    }

    public UpdateStarBadgeS2CPacket(UUID uuid, BaseInventory inventory) {
        this.inventories = new HashMap<UUID, BaseInventory>();
        this.inventories.put(uuid, inventory);
    }

    @Override
    public void onReceive(class_634 listener) {
        Map<UUID, BaseInventory> profiles = StarBadgeData.CLIENT.getInventories();
        if (this.inventories == null) {
            profiles.clear();
        } else {
            this.inventories.forEach((uuid, profile) -> {
                if (profile == null) {
                    profiles.remove(uuid);
                } else {
                    profiles.put((UUID)uuid, (BaseInventory)profile);
                }
            });
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.BOOLEAN.writeBits(this.inventories == null, buffer);
        if (this.inventories != null) {
            Adapters.INT_SEGMENTED_3.writeBits(this.inventories.size(), buffer);
            this.inventories.forEach((uuid, inventory) -> {
                Adapters.UUID.writeBits((UUID)uuid, buffer);
                Adapters.COMPOUND_NBT.asNullable().writeBits(inventory == null ? null : (class_2487)inventory.writeNbt().orElse(null), buffer);
            });
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
            this.inventories = null;
        } else {
            this.inventories = new HashMap<UUID, BaseInventory>();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                UUID uuid = Adapters.UUID.readBits(buffer).orElseThrow();
                BaseInventory inventory = Adapters.COMPOUND_NBT.asNullable().readBits(buffer).map(tag -> {
                    BaseInventory value = new BaseInventory(new class_1799[0]);
                    value.readNbt((class_2487)tag);
                    return value;
                }).orElse(null);
                this.inventories.put(uuid, inventory);
            }
        }
    }
}

