/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.basic.EnumAdapter;
import abeshutt.staracademy.data.item.ItemPredicate;
import abeshutt.staracademy.data.serializable.ISerializable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;

public class ItemUseLogic
implements ISerializable<class_2487, JsonObject> {
    private ItemPredicate predicate;
    private final List<String> commands;
    private CommandExecutionContext context;
    private boolean consumable;

    public ItemUseLogic() {
        this.commands = new ArrayList<String>();
    }

    public ItemUseLogic(String predicate, boolean consumable, CommandExecutionContext context, String ... commands) {
        this.predicate = ItemPredicate.of(predicate, true).orElseThrow();
        this.context = context;
        this.commands = new ArrayList<String>(Arrays.asList(commands));
        this.consumable = consumable;
    }

    public ItemPredicate getPredicate() {
        return this.predicate;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public CommandExecutionContext getContext() {
        return this.context;
    }

    public boolean isConsumable() {
        return this.consumable;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            Adapters.ITEM_PREDICATE.writeJson(this.predicate).ifPresent(tag -> json.add("predicate", tag));
            JsonArray commands = new JsonArray();
            this.commands.forEach(command -> Adapters.UTF_8.writeJson((String)command).ifPresent(arg_0 -> ((JsonArray)commands).add(arg_0)));
            json.add("commands", (JsonElement)commands);
            Adapters.ofEnum(CommandExecutionContext.class, EnumAdapter.Mode.NAME).writeJson(this.context).ifPresent(tag -> json.add("context", tag));
            Adapters.BOOLEAN.writeJson(this.consumable).ifPresent(consumable -> json.add("consumable", consumable));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.predicate = Adapters.ITEM_PREDICATE.readJson(json.get("predicate")).orElse(ItemPredicate.FALSE);
        this.commands.clear();
        JsonElement jsonElement = json.get("commands");
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            for (JsonElement element : array) {
                Adapters.UTF_8.readJson(element).ifPresent(this.commands::add);
            }
        }
        this.context = Adapters.ofEnum(CommandExecutionContext.class, EnumAdapter.Mode.NAME).readJson(json.get("context")).orElse(CommandExecutionContext.SERVER);
        this.consumable = Adapters.BOOLEAN.readJson(json.get("consumable")).orElse(false);
    }

    public static enum CommandExecutionContext {
        PLAYER,
        SERVER;

    }
}

