/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class StarterEntry
implements ISerializable<class_2487, JsonObject> {
    private class_2960 pick;
    private final Map<class_2960, Integer> cooldowns = new HashMap<class_2960, Integer>();
    private class_2960 granted;
    private boolean available = false;
    private boolean changed = true;

    public class_2960 getPick() {
        return this.pick;
    }

    public void setPick(class_2960 pick) {
        this.pick = pick;
        this.setChanged(true);
    }

    public boolean isOnCooldown(class_2960 species) {
        return this.cooldowns.getOrDefault(species, 0) > 0;
    }

    public void putOnCooldown(class_2960 species, int rounds) {
        this.cooldowns.put(species, Math.max(this.cooldowns.getOrDefault(species, 0), rounds));
        this.setChanged(true);
    }

    public class_2960 getGranted() {
        return this.granted;
    }

    public void setGranted(class_2960 granted) {
        this.granted = granted;
        this.setChanged(true);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
        this.setChanged(true);
    }

    public void onCompleteRound(int cooldown) {
        if (this.pick != null) {
            this.cooldowns.put(this.pick, this.cooldowns.getOrDefault(this.pick, 0) + cooldown + 1);
        }
        Iterator<Map.Entry<class_2960, Integer>> iterator = this.cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2960, Integer> entry = iterator.next();
            entry.setValue(entry.getValue() - 1);
            if (entry.getValue() > 0) continue;
            iterator.remove();
        }
        this.pick = null;
        this.setChanged(true);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.IDENTIFIER.asNullable().writeBits(this.pick, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.cooldowns.size(), buffer);
        this.cooldowns.forEach((species, rounds) -> {
            Adapters.IDENTIFIER.writeBits((class_2960)species, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(rounds, buffer);
        });
        Adapters.IDENTIFIER.asNullable().writeBits(this.granted, buffer);
        Adapters.BOOLEAN.writeBits(this.available, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.pick = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.cooldowns.clear();
        for (int i = 0; i < size; ++i) {
            this.cooldowns.put(Adapters.IDENTIFIER.readBits(buffer).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
        }
        this.granted = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
        this.available = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.IDENTIFIER.writeNbt(this.pick).ifPresent(tag -> nbt.method_10566("pick", tag));
            class_2487 cooldowns = new class_2487();
            this.cooldowns.forEach((species, rounds) -> Adapters.INT.writeNbt(rounds).ifPresent(tag -> cooldowns.method_10566(species.toString(), tag)));
            nbt.method_10566("cooldowns", (class_2520)cooldowns);
            Adapters.IDENTIFIER.writeNbt(this.granted).ifPresent(tag -> nbt.method_10566("granted", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.pick = Adapters.IDENTIFIER.readNbt(nbt.method_10580("pick")).orElse(null);
        class_2487 cooldowns = nbt.method_10562("cooldowns");
        this.cooldowns.clear();
        for (String key : cooldowns.method_10541()) {
            Adapters.INT.readNbt((class_2520)cooldowns.method_10562(key)).ifPresent(tag -> this.cooldowns.put(class_2960.method_12829((String)key), (Integer)tag));
        }
        this.granted = Adapters.IDENTIFIER.readNbt(nbt.method_10580("granted")).orElse(null);
    }
}

