/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.entity.PartialEntity;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import abeshutt.staracademy.data.serializable.INbtSerializable;
import abeshutt.staracademy.data.tile.PartialBlockState;
import abeshutt.staracademy.data.tile.PartialTile;
import abeshutt.staracademy.init.ModBlocks;
import abeshutt.staracademy.world.IdMapper;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_155;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2682;

public class StructureTemplate
implements INbtSerializable<class_2487> {
    public static final Comparator<PartialTile> SORTER = Comparator.comparingInt(tile -> tile.getPos().method_10264()).thenComparingInt(tile -> tile.getPos().method_10263()).thenComparingInt(tile -> tile.getPos().method_10260());
    private List<PartialTile> tiles = new ArrayList<PartialTile>();
    private List<PartialEntity> entities = new ArrayList<PartialEntity>();
    private IdPalette palette;
    private class_2382 size = class_2382.field_11176;

    public static StructureTemplate fromPath(String path) {
        class_2487 nbt;
        try {
            nbt = class_2507.method_10629((InputStream)new FileInputStream(path));
        }
        catch (IOException e) {
            return null;
        }
        StructureTemplate template = new StructureTemplate();
        template.readNbt(nbt);
        return template;
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        if (this.tiles.isEmpty()) {
            nbt.method_10566("blocks", (class_2520)new class_2499());
            nbt.method_10566("palette", (class_2520)new class_2499());
        } else {
            class_2499 blocksNBT = new class_2499();
            for (PartialTile partialTile : this.tiles) {
                int paletteId = this.palette.getIdFor(partialTile.getState());
                blocksNBT.add((Object)this.toPaletteNBT(partialTile, new class_2487(), paletteId));
            }
            nbt.method_10566("blocks", (class_2520)blocksNBT);
            class_2499 paletteNBT = new class_2499();
            for (PartialBlockState state : this.palette) {
                Adapters.PARTIAL_BLOCK_STATE.writeNbt(state).ifPresent(arg_0 -> paletteNBT.add(arg_0));
            }
            nbt.method_10566("palette", (class_2520)paletteNBT);
        }
        class_2499 entitiesNBT = new class_2499();
        for (PartialEntity partialEntity : this.entities) {
            class_2487 entityNBT = new class_2487();
            class_2499 posNBT = new class_2499();
            posNBT.add((Object)class_2489.method_23241((double)partialEntity.getPos().field_1352));
            posNBT.add((Object)class_2489.method_23241((double)partialEntity.getPos().field_1351));
            posNBT.add((Object)class_2489.method_23241((double)partialEntity.getPos().field_1350));
            entityNBT.method_10566("pos", (class_2520)posNBT);
            class_2499 blockPosNBT = new class_2499();
            blockPosNBT.add((Object)class_2497.method_23247((int)partialEntity.getBlockPos().method_10263()));
            blockPosNBT.add((Object)class_2497.method_23247((int)partialEntity.getBlockPos().method_10264()));
            blockPosNBT.add((Object)class_2497.method_23247((int)partialEntity.getBlockPos().method_10260()));
            entityNBT.method_10566("blockPos", (class_2520)blockPosNBT);
            partialEntity.getNbt().asWhole().ifPresent(tag -> entityNBT.method_10566("nbt", (class_2520)tag));
            entitiesNBT.add((Object)entityNBT);
        }
        nbt.method_10566("entities", (class_2520)entitiesNBT);
        class_2499 sizeNBT = new class_2499();
        sizeNBT.add((Object)class_2497.method_23247((int)this.size.method_10263()));
        sizeNBT.add((Object)class_2497.method_23247((int)this.size.method_10264()));
        sizeNBT.add((Object)class_2497.method_23247((int)this.size.method_10260()));
        nbt.method_10566("size", (class_2520)sizeNBT);
        nbt.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.tiles.clear();
        this.entities.clear();
        class_2499 sizeNBT = nbt.method_10554("size", 3);
        this.size = new class_2382(sizeNBT.method_10600(0), sizeNBT.method_10600(1), sizeNBT.method_10600(2));
        class_2499 blocksNBT = nbt.method_10554("blocks", 10);
        if (nbt.method_10573("palettes", 9)) {
            this.loadPalette(nbt.method_10554("palettes", 9).method_10603(0), blocksNBT);
            StarAcademyMod.LOGGER.error("Template does not support multiple palettes, using the first one instead");
        } else {
            this.loadPalette(nbt.method_10554("palette", 10), blocksNBT);
        }
        class_2499 entitiesNBT = nbt.method_10554("entities", 10);
        for (int j = 0; j < entitiesNBT.size(); ++j) {
            class_2487 entityNBT = entitiesNBT.method_10602(j);
            class_2499 posNBT = entityNBT.method_10554("pos", 6);
            class_243 pos = new class_243(posNBT.method_10611(0), posNBT.method_10611(1), posNBT.method_10611(2));
            class_2499 blockPosNBT = entityNBT.method_10554("blockPos", 3);
            class_2338 blockPos = new class_2338(blockPosNBT.method_10600(0), blockPosNBT.method_10600(1), blockPosNBT.method_10600(2));
            if (!entityNBT.method_10545("nbt")) continue;
            PartialEntity entity = PartialEntity.of(pos, blockPos, PartialCompoundNbt.of(entityNBT.method_10562("nbt")));
            this.entities.add(entity);
        }
    }

    private void loadPalette(class_2499 paletteNBT, class_2499 blocksNBT) {
        this.palette = new IdPalette();
        for (int i = 0; i < paletteNBT.size(); ++i) {
            PartialBlockState state = Adapters.PARTIAL_BLOCK_STATE.readNbt((class_2520)paletteNBT.method_10602(i)).orElse(null);
            if (state == null) continue;
            this.palette.addMapping(state, i);
        }
        ArrayList normal = Lists.newArrayList();
        ArrayList withNBT = Lists.newArrayList();
        ArrayList withSpecialShape = Lists.newArrayList();
        for (int j = 0; j < blocksNBT.size(); ++j) {
            class_2487 blockNBT = blocksNBT.method_10602(j);
            PartialTile tile = StructureTemplate.fromPaletteNBT(blockNBT, this.palette::getStateFor);
            class_2680 state = tile.getState().asWhole().orElse(((class_2248)ModBlocks.ERROR.get()).method_9564());
            if (tile.getEntity().asWhole().isPresent()) {
                withNBT.add(tile);
                continue;
            }
            if (!state.method_26204().method_9543() && state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) {
                normal.add(tile);
                continue;
            }
            withSpecialShape.add(tile);
        }
        this.tiles.addAll(StructureTemplate.getOrderedTiles(normal, withNBT, withSpecialShape));
    }

    private static List<PartialTile> getOrderedTiles(List<PartialTile> normal, List<PartialTile> withNBT, List<PartialTile> withSpecialShape) {
        normal.sort(SORTER);
        withSpecialShape.sort(SORTER);
        withNBT.sort(SORTER);
        ArrayList<PartialTile> tiles = new ArrayList<PartialTile>();
        tiles.addAll(normal);
        tiles.addAll(withSpecialShape);
        tiles.addAll(withNBT);
        return tiles;
    }

    public class_2520 toPaletteNBT(PartialTile tile, class_2487 nbt, int index) {
        nbt.method_10569("state", index);
        tile.getEntity().asWhole().ifPresent(tag -> nbt.method_10566("nbt", (class_2520)tag.method_10553()));
        if (tile.getPos() != null) {
            class_2499 posNBT = new class_2499();
            posNBT.add((Object)class_2497.method_23247((int)tile.getPos().method_10263()));
            posNBT.add((Object)class_2497.method_23247((int)tile.getPos().method_10264()));
            posNBT.add((Object)class_2497.method_23247((int)tile.getPos().method_10260()));
            nbt.method_10566("pos", (class_2520)posNBT);
        }
        return nbt;
    }

    public static PartialTile fromPaletteNBT(class_2487 tag, Function<Integer, PartialBlockState> stateFunction) {
        PartialBlockState state = PartialBlockState.of(((class_2248)ModBlocks.ERROR.get()).method_9564());
        PartialCompoundNbt nbt = PartialCompoundNbt.empty();
        class_2338 pos = null;
        if (tag.method_10573("state", 3)) {
            state = stateFunction.apply(tag.method_10550("state"));
        }
        if (tag.method_10573("pos", 9)) {
            class_2499 posNBT = tag.method_10554("pos", 3);
            pos = new class_2338(posNBT.method_10600(0), posNBT.method_10600(1), posNBT.method_10600(2));
        }
        if (tag.method_10573("nbt", 10)) {
            nbt = PartialCompoundNbt.of(tag.method_10562("nbt"));
        }
        return PartialTile.of(state, nbt, pos);
    }

    public static class IdPalette
    implements Iterable<PartialBlockState> {
        public static final PartialBlockState DEFAULT_STATE = PartialBlockState.of(((class_2248)ModBlocks.ERROR.get()).method_9564());
        private final IdMapper<PartialBlockState> ids = new IdMapper(16);
        private int nextId;

        public int getIdFor(PartialBlockState pState) {
            int i = this.ids.getId(pState);
            if (i == -1) {
                i = this.nextId++;
                this.ids.addMapping(pState, i);
            }
            return i;
        }

        public PartialBlockState getStateFor(int id) {
            PartialBlockState state = this.ids.byId(id);
            return state == null ? DEFAULT_STATE : state;
        }

        public void addMapping(PartialBlockState state, int id) {
            this.ids.addMapping(state, id);
        }

        @Override
        public Iterator<PartialBlockState> iterator() {
            return this.ids.iterator();
        }
    }
}

