/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModItems;
import abeshutt.staracademy.init.ModNetwork;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.item.StarBadgeItem;
import abeshutt.staracademy.net.UpdateStarBadgeS2CPacket;
import abeshutt.staracademy.world.StarOwnership;
import abeshutt.staracademy.world.data.WorldData;
import abeshutt.staracademy.world.inventory.BaseInventory;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class StarBadgeData
extends WorldData {
    public static final StarBadgeData CLIENT = new StarBadgeData();
    private final Map<UUID, BaseInventory> inventories = new LinkedHashMap<UUID, BaseInventory>();

    public Map<UUID, BaseInventory> getInventories() {
        return this.inventories;
    }

    public BaseInventory getOrCreate(class_1657 player) {
        if (this.inventories.containsKey(player.method_5667())) {
            return this.inventories.get(player.method_5667());
        }
        BaseInventory inventory = new BaseInventory(10);
        this.inventories.put(player.method_5667(), inventory);
        inventory.addListener(sender -> this.method_80());
        for (class_1799 stack : ModConfigs.STAR_BADGE.getStartItems()) {
            inventory.addStack(stack);
        }
        this.method_80();
        if (player.method_5682() != null) {
            ModNetwork.CHANNEL.sendToPlayers((Iterable)player.method_5682().method_3760().method_14571(), (Object)new UpdateStarBadgeS2CPacket(player.method_5667(), inventory));
        }
        return inventory;
    }

    public void onTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            this.getOrCreate((class_1657)player);
        }
        HashSet changed = new HashSet();
        this.inventories.forEach((uuid, inventory) -> {
            for (int slot = 0; slot < inventory.method_5439(); ++slot) {
                List<StarOwnership> ownership;
                class_1799 stack = inventory.method_5438(slot);
                if (!stack.method_31574((class_1792)ModItems.STAR_BADGE.get()) || !(ownership = StarBadgeItem.getOwnership(stack)).isEmpty() && ownership.get(ownership.size() - 1).getUuid().equals(uuid)) continue;
                ownership.add(StarOwnership.ofNow(uuid));
                StarBadgeItem.setOwnership(stack, ownership);
                inventory.method_5447(slot, stack);
                changed.add(uuid);
            }
            if (inventory.isDirty()) {
                changed.add(uuid);
                inventory.setDirty(false);
            }
        });
        if (!changed.isEmpty()) {
            for (UUID uuid2 : changed) {
                ModNetwork.CHANNEL.sendToPlayers((Iterable)server.method_3760().method_14571(), (Object)new UpdateStarBadgeS2CPacket(uuid2, this.inventories.get(uuid2)));
            }
        }
    }

    private void onJoin(class_3222 player) {
        ModNetwork.CHANNEL.sendToPlayer(player, (Object)new UpdateStarBadgeS2CPacket(null));
        ModNetwork.CHANNEL.sendToPlayer(player, (Object)new UpdateStarBadgeS2CPacket(this.inventories));
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            this.inventories.forEach((uuid, inventory) -> inventory.writeNbt().ifPresent(tag -> nbt.method_10566(uuid.toString(), (class_2520)tag)));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.inventories.clear();
        for (String key : nbt.method_10541()) {
            BaseInventory inventory = new BaseInventory(new class_1799[0]);
            inventory.readNbt(nbt.method_10562(key));
            this.inventories.put(UUID.fromString(key), inventory);
            inventory.addListener(sender -> this.method_80());
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            StarBadgeData data = ModWorldData.STAR_BADGE.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            StarBadgeData data = ModWorldData.STAR_BADGE.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

