/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.dhks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.iafenvoy.dhks.DefaultHotkeys;
import com.iafenvoy.dhks.Keys;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2477;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class KeyConfig {
    private static final Codec<Map<String, KeyObject>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("comment", (Object)"").forGetter(KeyObject::comment), (App)Codec.STRING.fieldOf("key").forGetter(KeyObject::key), (App)Codec.STRING.optionalFieldOf("modifier", (Object)"").forGetter(KeyObject::modifier)).apply((Applicative)i, KeyObject::new)));
    private static final Map<String, KeyObject> CONFIGS = new TreeMap<String, KeyObject>();
    private static final String CONFIG_PATH = "./config/default-hotkeys.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static int find(String translation, int code, String modifier) {
        if (CONFIGS.containsKey(translation)) {
            return Keys.getCode(KeyConfig.CONFIGS.get((Object)translation).key);
        }
        CONFIGS.put(translation, new KeyObject(class_2477.method_10517().method_4679(translation, class_1074.method_4662((String)translation, (Object[])new Object[0])), Keys.getTranslate(code), modifier));
        return code;
    }

    public static void save() {
        try {
            FileUtils.write((File)new File(CONFIG_PATH), (CharSequence)GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, CONFIGS).resultOrPartial(arg_0 -> ((Logger)DefaultHotkeys.LOGGER).error(arg_0)).orElseThrow()), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            DefaultHotkeys.LOGGER.error("Failed to save {}", (Object)CONFIG_PATH, (Object)e);
        }
    }

    static {
        try {
            CONFIGS.putAll((Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)FileUtils.readFileToString((File)new File(CONFIG_PATH), (Charset)StandardCharsets.UTF_8))).resultOrPartial(arg_0 -> ((Logger)DefaultHotkeys.LOGGER).error(arg_0)).orElseThrow());
        }
        catch (Exception e) {
            DefaultHotkeys.LOGGER.error("Failed to load {}", (Object)CONFIG_PATH, (Object)e);
        }
    }

    private record KeyObject(String comment, String key, String modifier) {
    }
}

