/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.blockentity;

import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.ModBlocks;
import com.cstav.evenmoreinstruments.block.blockentity.ModBlockEntities;
import com.cstav.evenmoreinstruments.block.util.WritableNoteType;
import com.cstav.evenmoreinstruments.gamerule.ModGameRules;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.mixins.util.InjectedBlockEntity;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperRecordEntityData;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldNoteSoundPacketUtil;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.networking.packet.instrument.util.NoteSoundPacketUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.util.BiValue;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8181;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class LooperBlockEntity
extends class_2586
implements class_8181 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String RECORD_TAG = "Record";
    public static final String RECORDING_TAG = "Recording";
    public static final String TICKS_TAG = "Ticks";
    private boolean locked = false;
    private class_1657 lockedBy = null;
    private class_1799 recordIn = class_1799.field_8037;
    private class_2487 channel;
    private final InitiatorID looperInitiatorID;
    protected final HashSet<BiValue<HeldNoteSound, NoteSoundMetadata>> cachedHeldNotes = new HashSet();

    protected void stopAndClearHeldSounds() {
        this.notifyHeldNotesPhase(HeldSoundPhase.RELEASE);
        this.cachedHeldNotes.clear();
    }

    public class_2487 getPersistentData() {
        return ((InjectedBlockEntity)((Object)this)).evenmoreinstruments$getModTag();
    }

    public class_2487 getChannel() {
        return this.channel;
    }

    private void setChannel(class_2487 channel) {
        this.channel = channel;
    }

    private void updateChannel() {
        class_2487 recordData = this.recordIn.method_7948();
        if (recordData.method_10573("Channel", 10)) {
            this.channel = recordData.method_10562("Channel");
        } else if (recordData.method_10573("BurnedMedia", 8)) {
            this.setChannel(RecordRepository.getRecord(this.getBurnedMediaLoc()).orElse(null));
        }
    }

    protected class_2960 getBurnedMediaLoc() {
        return new class_2960(this.recordIn.method_7969().method_10558("BurnedMedia"));
    }

    private void updateRecordNBT() {
        this.getPersistentData().method_10566(RECORD_TAG, (class_2520)this.recordIn.method_7953(new class_2487()));
    }

    public boolean hasFootage() {
        class_2487 channel = this.getChannel();
        return channel != null && channel.method_10573("Notes", 9) && !channel.method_10554("Notes", 10).isEmpty();
    }

    public boolean isWritable() {
        return this.getChannel() != null && this.getChannel().method_10577("Writable");
    }

    public void setWritable(boolean writable) {
        this.getChannel().method_10556("Writable", writable);
    }

    public boolean isRecordIn() {
        return !this.recordIn.method_7960();
    }

    protected class_2487 getRecordData() {
        return this.recordIn.method_7948();
    }

    public void method_11014(class_2487 pTag) {
        super.method_11014(pTag);
        this.recordIn = class_1799.method_7915((class_2487)this.getPersistentData().method_10562(RECORD_TAG));
        this.updateChannel();
    }

    public class_1799 method_5438(int pSlot) {
        return this.recordIn;
    }

    public void method_5447(int pSlot, class_1799 pStack) {
        class_1792 class_17922 = pStack.method_7909();
        if (!(class_17922 instanceof EMIRecordItem)) {
            return;
        }
        EMIRecordItem recordItem = (EMIRecordItem)class_17922;
        this.recordIn = pStack.method_46651(1);
        recordItem.onInsert(this.recordIn, this);
        this.updateChannel();
        class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(true));
        if (this.hasFootage()) {
            newState = this.setPlaying(true, newState);
        }
        this.updateRecordNBT();
        this.method_10997().method_8652(this.method_11016(), newState, 3);
        this.method_5431();
    }

    public class_1799 method_5434(int pSlot, int pAmount) {
        if (!this.isRecordIn() || pAmount <= 0) {
            return class_1799.field_8037;
        }
        class_1799 prev = this.recordIn;
        this.recordIn = class_1799.field_8037;
        this.method_10997().method_8652(this.method_11016(), (class_2680)this.setPlaying(false, this.method_11010()).method_11657((class_2769)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(false)), 3);
        this.getPersistentData().method_10551(RECORD_TAG);
        this.reset();
        return prev;
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5443(class_1657 pPlayer) {
        return class_1263.method_49105((class_2586)this, (class_1657)pPlayer);
    }

    public boolean method_5437(int pIndex, class_1799 pStack) {
        return pStack.method_7909() instanceof EMIRecordItem && !this.isRecordIn();
    }

    public boolean method_49104(class_1263 pTarget, int pIndex, class_1799 pStack) {
        return !this.isRecordIn();
    }

    public LooperBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlockEntities.LOOPER, pPos, pBlockState);
        this.looperInitiatorID = new InitiatorID("block", String.format("x%sy%sz%s", pPos.method_10263(), pPos.method_10264(), pPos.method_10260()));
        class_2487 data = this.getPersistentData();
        if (!data.method_10573(TICKS_TAG, 3)) {
            this.setTicks(0);
        }
    }

    public void setRecording(boolean recording) {
        this.getPersistentData().method_10556(RECORDING_TAG, recording);
    }

    public void setTicks(int ticks) {
        this.getPersistentData().method_10569(TICKS_TAG, ticks);
    }

    public int incrementTick() {
        int ticks = this.getTicks();
        int repTick = this.getRepeatTick();
        ticks = repTick != -1 && ticks > repTick ? this.onLooperEnd() : ++ticks;
        this.setTicks(ticks);
        return ticks;
    }

    public int onLooperEnd() {
        if (!((Boolean)this.method_11010().method_11654((class_2769)LooperBlock.LOOPING)).booleanValue()) {
            this.method_10997().method_8501(this.method_11016(), this.setPlaying(false, this.method_11010()));
        }
        this.stopAndClearHeldSounds();
        return 0;
    }

    public void setRepeatTick(int tick) {
        this.getChannel().method_10569("RepeatTick", tick);
    }

    public void setLockedBy(class_1657 player) {
        this.lockedBy = player;
    }

    public void lock() {
        this.locked = true;
        this.lockedBy = null;
        this.setRepeatTick(this.getTicks());
        this.setRecording(false);
        this.setWritable(false);
        this.setTicks(0);
        this.updateRecordNBT();
        this.method_5431();
    }

    public void reset() {
        this.locked = false;
        this.lockedBy = null;
        this.stopAndClearHeldSounds();
        this.setTicks(0);
        this.method_5431();
    }

    public boolean isLocked() {
        return this.lockedByAnyone() || this.locked;
    }

    public boolean isRecording() {
        return this.getPersistentData().method_10577(RECORDING_TAG);
    }

    public boolean isAllowedToRecord(class_1657 player) {
        return !this.lockedByAnyone() || this.isLockedBy(player);
    }

    public boolean lockedByAnyone() {
        return this.lockedBy != null;
    }

    public boolean isLockedBy(class_1657 player) {
        return player.equals((Object)this.lockedBy);
    }

    public int getTicks() {
        return this.getPersistentData().method_10550(TICKS_TAG);
    }

    public int getRepeatTick() {
        class_2487 channel = this.getChannel();
        if (channel.method_10545("RepeatTick")) {
            return channel.method_10550("RepeatTick");
        }
        return -1;
    }

    public class_2680 setPlaying(boolean playing, class_2680 state) {
        boolean isPlaying = this.hasFootage() && playing;
        class_2680 newState = (class_2680)state.method_11657((class_2769)LooperBlock.PLAYING, (Comparable)Boolean.valueOf(isPlaying));
        if (!this.method_10997().field_9236) {
            this.method_10997().method_18456().forEach(player -> EMIPacketHandler.sendToClient((FabricPacket)new LooperPlayStatePacket(isPlaying, this.method_11016()), (class_3222)player));
            this.notifyHeldNotesPhase(playing ? HeldSoundPhase.ATTACK : HeldSoundPhase.RELEASE);
        }
        return newState;
    }

    private void notifyHeldNotesPhase(HeldSoundPhase phase) {
        this.cachedHeldNotes.forEach(bi -> HeldNoteSoundPacketUtil.sendPlayNotePackets((class_1937)this.field_11863, (HeldNoteSound)((HeldNoteSound)bi.obj1()), (NoteSoundMetadata)((NoteSoundMetadata)bi.obj2()), (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID));
    }

    public void writeNote(NoteSound sound, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        class_2487 noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.method_10582("NoteType", WritableNoteType.REGULAR.name());
        noteTag.method_10569("SoundIndex", sound.index);
        noteTag.method_10582("SoundType", sound.baseSoundLocation.toString());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.method_5431();
    }

    public void writeHeldNote(HeldNoteSound sound, HeldSoundPhase phase, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        class_2487 noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.method_10582("NoteType", WritableNoteType.HELD.name());
        noteTag.method_10569("SoundIndex", sound.index());
        noteTag.method_10582("SoundType", sound.baseSoundLocation().toString());
        noteTag.method_10582("HeldPhase", phase.name());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.method_5431();
    }

    protected class_2487 serializeNoteMeta(NoteSoundMetadata soundMeta, int timestamp) {
        class_2487 noteTag = new class_2487();
        noteTag.method_10569("Pitch", soundMeta.pitch());
        noteTag.method_10548("Volume", (float)soundMeta.volume() / 100.0f);
        noteTag.method_10569("Timestamp", timestamp);
        return noteTag;
    }

    public void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
        LooperBlockEntity lbe = LooperUtil.getFromPos(pLevel, pPos);
        boolean isPlaying = (Boolean)lbe.method_11010().method_11654((class_2769)LooperBlock.PLAYING);
        if (!isPlaying && !lbe.isRecording()) {
            return;
        }
        if (lbe.isRecording()) {
            lbe.incrementTick();
        }
        if (!isPlaying) {
            return;
        }
        class_2487 channel = lbe.getChannel();
        if (channel == null) {
            return;
        }
        int ticks = this.getTicks();
        class_2960 instrumentId = new class_2960(channel.method_10558("InstrumentId"));
        channel.method_10554("Notes", 10).stream().map(note -> (class_2487)note).filter(note -> note.method_10550("Timestamp") == ticks).forEach(note -> lbe.playNote((class_2487)note, instrumentId));
        lbe.incrementTick();
    }

    private void playNote(class_2487 note, class_2960 instrumentId) {
        try {
            String rawNoteType = note.method_10558("NoteType");
            WritableNoteType noteType = rawNoteType.isEmpty() ? WritableNoteType.REGULAR : WritableNoteType.valueOf(rawNoteType);
            switch (noteType) {
                case REGULAR: {
                    this.playNoteSound(note, instrumentId);
                    break;
                }
                case HELD: {
                    this.playHeldSound(note, instrumentId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Attempted to play a looper note at {}, but met with an exception", (Object)this.method_11016(), (Object)e);
        }
    }

    protected void playNoteSound(class_2487 noteTag, class_2960 instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        class_2960 soundLocation = new class_2960(noteTag.method_10558("SoundType"));
        int soundIndex = noteTag.method_10550("SoundIndex");
        NoteSoundPacketUtil.sendPlayNotePackets((class_1937)this.field_11863, (NoteSound)NoteSoundRegistrar.getSounds((class_2960)soundLocation)[soundIndex], (NoteSoundMetadata)meta);
        this.triggerEmitNoteParticle(meta.pitch());
    }

    protected void playHeldSound(class_2487 noteTag, class_2960 instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        class_2960 soundLocation = new class_2960(noteTag.method_10558("SoundType"));
        int soundIndex = noteTag.method_10550("SoundIndex");
        HeldNoteSound sound = HeldNoteSoundRegistrar.getSounds((class_2960)soundLocation)[soundIndex];
        HeldSoundPhase phase = HeldSoundPhase.valueOf((String)noteTag.method_10558("HeldPhase"));
        HeldNoteSoundPacketUtil.sendPlayNotePackets((class_1937)this.field_11863, (HeldNoteSound)sound, (NoteSoundMetadata)meta, (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID);
        if (phase == HeldSoundPhase.ATTACK) {
            this.cachedHeldNotes.add((BiValue<HeldNoteSound, NoteSoundMetadata>)new BiValue((Object)sound, (Object)meta));
            this.triggerEmitNoteParticle(meta.pitch());
        } else if (phase == HeldSoundPhase.RELEASE) {
            this.cachedHeldNotes.remove(new BiValue((Object)sound, (Object)meta));
        }
    }

    protected NoteSoundMetadata metaFromNoteTag(class_2487 noteTag, class_2960 instrumentId) {
        return new NoteSoundMetadata(this.method_11016(), noteTag.method_10550("Pitch"), (int)(noteTag.method_10583("Volume") * 100.0f), instrumentId, Optional.empty());
    }

    public void triggerEmitNoteParticle(int pitch) {
        this.method_10997().method_8427(this.method_11016(), ModBlocks.LOOPER, 42, pitch);
    }

    public void popRecord() {
        class_2487 recordData = this.getRecordData();
        if (this.recordIn.method_31574(ModItems.RECORD_WRITABLE)) {
            if (this.isWritable()) {
                recordData.method_10551("Notes");
            }
            if (!this.hasFootage()) {
                recordData.method_10551("Channel");
            }
        }
        this.stopAndClearHeldSounds();
        class_243 popVec = class_243.method_49273((class_2382)this.method_11016(), (double)0.5, (double)1.01, (double)0.5).method_49272(this.method_10997().field_9229, 0.7f);
        class_1542 itementity = new class_1542(this.method_10997(), popVec.method_10216(), popVec.method_10214(), popVec.method_10215(), this.recordIn);
        itementity.method_6988();
        this.method_10997().method_8649((class_1297)itementity);
        this.method_5434(0, 1);
    }

    public void method_11012() {
        super.method_11012();
        this.stopAndClearHeldSounds();
    }

    public boolean isCapped(class_1937 level) {
        int cap = level.method_8450().method_8356(ModGameRules.RULE_LOOPER_MAX_NOTES);
        return cap >= 0 && this.getChannel().method_10554("Notes", 10).size() >= cap;
    }

    public static void onPlayerLeave(class_3244 handler, MinecraftServer server) {
        class_3222 player = handler.method_32311();
        if (!LooperRecordEntityData.isRecording((class_1297)player)) {
            return;
        }
        player.method_37908().method_35230(LooperRecordEntityData.getLooperPos((class_1297)player), ModBlockEntities.LOOPER).filter(arg_0 -> LooperBlockEntity.lambda$onPlayerLeave$5((class_1657)player, arg_0)).ifPresent(lbe -> {
            lbe.reset();
            lbe.getPersistentData().method_10556(RECORDING_TAG, false);
        });
        LooperUtil.setNotRecording((class_1657)player);
    }

    private static /* synthetic */ boolean lambda$onPlayerLeave$5(class_1657 player, LooperBlockEntity lbe) {
        return lbe.lockedBy.equals((Object)player);
    }

    static {
        ServerPlayConnectionEvents.DISCONNECT.register(LooperBlockEntity::onPlayerLeave);
    }
}

