/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.blockentity;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

public class LooperNoteListener {
    public static void register() {
        NoteSoundPlayedEvent.EVENT.register(LooperNoteListener::onNoteSoundPlayed);
        HeldNoteSoundPlayedEvent.EVENT.register(LooperNoteListener::onHeldNoteSoundPlayed);
    }

    public static void onNoteSoundPlayed(NoteSoundPlayedEvent.NoteSoundPlayedEventArgs args) {
        LooperNoteListener.getMatchingLooper(args).ifPresent(looperBE -> looperBE.writeNote((NoteSound)args.sound(), args.soundMeta(), looperBE.getTicks()));
    }

    public static void onHeldNoteSoundPlayed(HeldNoteSoundPlayedEvent.HeldNoteSoundPlayedEventArgs args) {
        LooperNoteListener.getMatchingLooper(args).ifPresent(looperBE -> looperBE.writeHeldNote((HeldNoteSound)args.sound(), args.phase, args.soundMeta(), looperBE.getTicks()));
    }

    private static Optional<LooperBlockEntity> getMatchingLooper(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> event) {
        if (!event.isByPlayer()) {
            return Optional.empty();
        }
        class_1657 player = (class_1657)((InstrumentPlayedEvent.InstrumentPlayedEventArgs.EntityInfo)event.entityInfo().get()).entity;
        if (event.level().field_9236 || !LooperUtil.isRecording(player)) {
            return Optional.empty();
        }
        class_1937 level = player.method_37908();
        LooperBlockEntity looperBE = LooperUtil.getFromEvent(event);
        if (looperBE == null || looperBE.isCapped(level)) {
            return Optional.empty();
        }
        if (!looperBE.isWritable()) {
            return Optional.empty();
        }
        if (looperBE.isLocked()) {
            if (!looperBE.isRecording() || !looperBE.isAllowedToRecord(player)) {
                return Optional.empty();
            }
        } else {
            looperBE.setLockedBy(player);
            looperBE.setRecording(true);
            looperBE.getChannel().method_10582("InstrumentId", event.soundMeta().instrumentId().toString());
        }
        return Optional.of(looperBE);
    }
}

