/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.client.gui.instrument;

import com.cstav.evenmoreinstruments.client.KeyMappings;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.DoesLooperExistPacket;
import com.cstav.evenmoreinstruments.networking.packet.LooperRecordStatePacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class LooperOverlayInjector {
    private static final int REC_BTN_WIDTH = 120;
    private static InstrumentScreen screen = null;
    private static boolean isRecording = false;
    private static class_4185 recordBtn;

    public static void load() {
        ScreenEvents.AFTER_INIT.register(LooperOverlayInjector::afterScreenInit);
        ScreenEvents.BEFORE_INIT.register(LooperOverlayInjector::beforeScreenInit);
    }

    public static void afterScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof InstrumentScreen)) {
            return;
        }
        InstrumentScreen instrumentScreen = (InstrumentScreen)screen;
        class_746 player = class_310.method_1551().field_1724;
        if (InstrumentEntityData.isItem((class_1657)player)) {
            class_1268 hand = InstrumentEntityData.getHand((class_1657)player);
            class_1799 instrumentItem = player.method_5998(hand);
            if (!LooperUtil.hasLooperTag(instrumentItem)) {
                return;
            }
            EMIPacketHandler.sendToServer((FabricPacket)new DoesLooperExistPacket(hand));
        } else {
            class_2338 instrumentBlockPos = InstrumentEntityData.getBlockPos((class_1657)player);
            class_2586 instrumentBE = player.method_37908().method_8321(instrumentBlockPos);
            if (!LooperUtil.hasLooperTag(instrumentBE)) {
                return;
            }
            EMIPacketHandler.sendToServer((FabricPacket)new DoesLooperExistPacket());
        }
        LooperOverlayInjector.screen = instrumentScreen;
        recordBtn = class_4185.method_46430((class_2561)LooperOverlayInjector.appendRecordKeyHint(class_2561.method_43471((String)"button.evenmoreinstruments.record")), LooperOverlayInjector::onRecordPress).method_46432(120).method_46433((instrumentScreen.field_22789 - 120) / 2, 5).method_46431();
        Screens.getButtons((class_437)instrumentScreen).add(recordBtn);
        ScreenEvents.remove((class_437)instrumentScreen).register(LooperOverlayInjector::onScreenClose);
    }

    public static void beforeScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof InstrumentScreen)) {
            return;
        }
        ScreenKeyboardEvents.beforeKeyPress((class_437)screen).register(LooperOverlayInjector::onKeyboardPress);
    }

    public static void handleLooperRemoved() {
        LooperOverlayInjector.removeRecordButton();
        screen = null;
    }

    private static class_5250 appendRecordKeyHint(class_5250 component) {
        return component.method_27693(" (").method_10852(KeyMappings.RECORD.method_16007()).method_27693(")");
    }

    private static void onKeyboardPress(class_437 screen, int key, int scancode, int modifiers) {
        if (KeyMappings.RECORD.method_1417(key, scancode) && recordBtn != null) {
            recordBtn.method_25354(class_310.method_1551().method_1483());
            recordBtn.method_25306();
        }
    }

    private static void onScreenClose(class_437 screen) {
        if (LooperOverlayInjector.screen != screen) {
            return;
        }
        isRecording = false;
        LooperOverlayInjector.screen = null;
    }

    private static void onRecordPress(class_4185 btn) {
        class_1268 hand;
        class_746 player = class_310.method_1551().field_1724;
        boolean isItem = InstrumentEntityData.isItem((class_1657)player);
        class_1268 class_12682 = hand = isItem ? InstrumentEntityData.getHand((class_1657)class_310.method_1551().field_1724) : null;
        if (isRecording) {
            LooperOverlayInjector.removeRecordButton();
            screen = null;
        } else {
            btn.method_25355((class_2561)LooperOverlayInjector.appendRecordKeyHint(class_2561.method_43471((String)"button.evenmoreinstruments.stop")));
        }
        isRecording = !isRecording;
        EMIPacketHandler.sendToServer((FabricPacket)new LooperRecordStatePacket(isRecording, hand));
    }

    public static void removeRecordButton() {
        if (screen == null) {
            return;
        }
        Screens.getButtons((class_437)screen).remove(recordBtn);
        recordBtn = null;
    }
}

