/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.client.gui.instrument.partial;

import com.cstav.evenmoreinstruments.client.KeyMappings;
import com.cstav.evenmoreinstruments.client.gui.instrument.partial.CyclableSoundType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.SoundTypeOptionsScreen;
import com.cstav.genshinstrument.sound.NoteSound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class CyclableInstrumentScreen<T extends CyclableSoundType<T>>
extends GridInstrumentScreen {
    private T soundType = null;
    private boolean soundTypeChanged = false;

    public T getSoundType() {
        return this.soundType == null ? (this.soundType = this.defSoundType()) : this.soundType;
    }

    public void setSoundType(T soundType) {
        this.soundType = soundType;
    }

    public T defSoundType() {
        return (T)((CyclableSoundType)((SoundTypeOptionsScreen)this.optionsScreen).getPreferredSoundType());
    }

    public NoteSound[] getInitSounds() {
        return (NoteSound[])this.defSoundType().getSoundArr().get();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        return this.changeSoundType(pKeyCode, pScanCode, true) || super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        return this.changeSoundType(pKeyCode, pScanCode, false) || super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    public boolean isKeyConsumed(int keyCode, int scanCode) {
        return super.isKeyConsumed(keyCode, scanCode) || this.checkSoundTypeKey(keyCode, scanCode);
    }

    private boolean changeSoundType(int keyCode, int scanCode, boolean pressed) {
        if (!this.checkSoundTypeKey(keyCode, scanCode)) {
            return false;
        }
        if (pressed ? this.soundTypeChanged : !this.soundTypeChanged) {
            return false;
        }
        this.updateSoundType((CyclableSoundType)this.getSoundType().getNext());
        this.soundTypeChanged = pressed;
        return true;
    }

    private boolean checkSoundTypeKey(int keyCode, int scanCode) {
        return KeyMappings.INSTRUMENT_TYPE_MODIFIER.method_1417(keyCode, scanCode);
    }

    private void updateSoundType(T sound) {
        this.soundType = sound;
        this.setNoteSounds((NoteSound[])this.soundType.getSoundArr().get());
    }

    public void onOptionsOpen() {
        this.updateSoundType(this.defSoundType());
        super.onOptionsOpen();
    }

    protected abstract SoundTypeOptionsScreen<T> initInstrumentOptionsScreen();
}

