/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class LooperAdapterItem
extends class_1792 {
    private static final String BLOCK_INSTRUMENT_POS_TAG = "instrument_block";
    private static final String LOOPER_POS_TAG = "looper";

    public LooperAdapterItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public class_1269 method_7884(class_1838 pContext) {
        boolean pairSucceed;
        if (pContext.method_8045().field_9236) {
            return class_1269.field_33562;
        }
        class_2338 pos = pContext.method_8037();
        class_2248 block = pContext.method_8045().method_8320(pContext.method_8037()).method_26204();
        class_2487 adapterTag = CommonUtil.getOrCreateElementTag(EMIMain.modTag(pContext.method_8041()), "looperAdapter");
        class_1657 player = pContext.method_8036();
        if (block instanceof AbstractInstrumentBlock) {
            pairSucceed = LooperAdapterItem.handleInstrumentBlock(pos, adapterTag, player);
        } else if (block instanceof LooperBlock) {
            pairSucceed = LooperAdapterItem.handleLooperBlock(pos, adapterTag, player);
        } else {
            return class_1269.field_5814;
        }
        return pairSucceed ? class_1269.field_5812 : class_1269.field_33562;
    }

    private static boolean handleInstrumentBlock(class_2338 blockPos, class_2487 adapterTag, class_1657 player) {
        if (adapterTag.method_10573(LOOPER_POS_TAG, 10)) {
            return LooperAdapterItem.pairLooperToInstrument(adapterTag, class_2512.method_10691((class_2487)adapterTag.method_10562(LOOPER_POS_TAG)), blockPos, player);
        }
        adapterTag.method_10566(BLOCK_INSTRUMENT_POS_TAG, (class_2520)class_2512.method_10692((class_2338)blockPos));
        player.method_7353((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.looper.select"), true);
        return true;
    }

    private static boolean handleLooperBlock(class_2338 blockPos, class_2487 adapterTag, class_1657 player) {
        class_2586 be = player.method_37908().method_8321(blockPos);
        if (!(be instanceof LooperBlockEntity)) {
            return false;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        if (!lbe.isRecordIn()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"evenmoreinstruments.looper.no_record").method_27692(class_124.field_1061), true);
            return false;
        }
        if (adapterTag.method_10573(BLOCK_INSTRUMENT_POS_TAG, 10)) {
            return LooperAdapterItem.pairLooperToInstrument(adapterTag, blockPos, class_2512.method_10691((class_2487)adapterTag.method_10562(BLOCK_INSTRUMENT_POS_TAG)), player);
        }
        if (adapterTag.method_10573(LOOPER_POS_TAG, 10)) {
            return LooperAdapterItem.syncLoopers(adapterTag, class_2512.method_10691((class_2487)adapterTag.method_10562(LOOPER_POS_TAG)), blockPos, player);
        }
        adapterTag.method_10566(LOOPER_POS_TAG, (class_2520)class_2512.method_10692((class_2338)blockPos));
        player.method_7353((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.instrument.select").method_27692(class_124.field_1060), true);
        return true;
    }

    private static boolean pairLooperToInstrument(class_2487 adapterTag, InstrumentBlockEntity ibe, LooperBlockEntity lbe, class_1657 player) {
        for (String key : adapterTag.method_10541()) {
            adapterTag.method_10551(key);
        }
        return LooperUtil.performPair(lbe, () -> {
            class_2680 instrumentBlockState = ibe.method_11010();
            class_2248 instrumentBlock = instrumentBlockState.method_26204();
            class_2338 instrumentBlockPos = ibe.method_11016();
            class_2338 looperBlockPos = lbe.method_11016();
            class_2338 otherBlockPos = null;
            if (instrumentBlock instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)instrumentBlock;
                otherBlockPos = doubleBlock.getOtherBlock(instrumentBlockState, instrumentBlockPos, player.method_37908());
            }
            LooperUtil.createLooperTag((class_2586)ibe, looperBlockPos);
            if (otherBlockPos != null) {
                LooperUtil.createLooperTag(player.method_37908().method_8321(otherBlockPos), looperBlockPos);
            }
            ibe.method_5431();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                EMIPacketHandler.sendToClient((FabricPacket)new SyncModTagPacket(EMIMain.modTag((class_2586)ibe), instrumentBlockPos), serverPlayer);
                if (otherBlockPos != null) {
                    EMIPacketHandler.sendToClient((FabricPacket)new SyncModTagPacket(EMIMain.modTag((class_2586)ibe), otherBlockPos), serverPlayer);
                }
            }
        }, player);
    }

    private static boolean pairLooperToInstrument(class_2487 adapterTag, class_2338 looperPos, class_2338 instrumentPos, class_1657 player) {
        class_1937 level = player.method_37908();
        class_2586 lbe = level.method_8321(looperPos);
        class_2586 ibe = level.method_8321(instrumentPos);
        if (!(lbe instanceof LooperBlockEntity) || !(ibe instanceof InstrumentBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.pairLooperToInstrument(adapterTag, (InstrumentBlockEntity)ibe, (LooperBlockEntity)lbe, player);
    }

    private static boolean syncLoopers(class_2487 adapterTag, LooperBlockEntity lbe1, LooperBlockEntity lbe2, class_1657 player) {
        if (lbe1.method_11016().equals((Object)lbe2.method_11016())) {
            return false;
        }
        for (String key : adapterTag.method_10541()) {
            adapterTag.method_10551(key);
        }
        if (!lbe1.hasFootage() || !lbe1.hasFootage()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"evenmoreinstruments.record.no_footage").method_27692(class_124.field_1061), true);
            return true;
        }
        lbe2.setRepeatTick(lbe1.getRepeatTick());
        lbe2.setTicks(lbe1.getTicks());
        player.method_7353((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.instrument.success_pair").method_27692(class_124.field_1060), true);
        return true;
    }

    private static boolean syncLoopers(class_2487 adapterTag, class_2338 looper1Pos, class_2338 looper2Pos, class_1657 player) {
        if (looper2Pos.equals((Object)looper1Pos)) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_2586 lbe1 = level.method_8321(looper1Pos);
        class_2586 lbe2 = level.method_8321(looper2Pos);
        if (!(lbe1 instanceof LooperBlockEntity) || !(lbe2 instanceof LooperBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.syncLoopers(adapterTag, (LooperBlockEntity)lbe1, (LooperBlockEntity)lbe2, player);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        if (!class_437.method_25442()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.shift.hint.show").method_27692(class_124.field_1054));
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.shift.hint.hide").method_27692(class_124.field_1054));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.instrument.description").method_27692(class_124.field_1080));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.looper.description").method_27692(class_124.field_1080));
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
    }
}

