/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.emirecord;

import com.cstav.evenmoreinstruments.server.MCServerInstance;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_151;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_5218;
import org.slf4j.Logger;

public class RecordRepository {
    private static final ConcurrentHashMap<class_2960, class_2487> RECORDS = new ConcurrentHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String RECORDS_DIR = "records";
    private static final String DATA_DIR = "evenmoreinstruments/records";

    public static void load() {
    }

    public static Optional<class_2487> getRecord(class_2960 loc) {
        return RECORDS.containsKey(loc) ? Optional.of(RECORDS.get(loc).method_10553()) : RecordRepository.tryGetRecordFromGen(loc);
    }

    public static Set<class_2960> getRecords() {
        return Collections.unmodifiableSet(RECORDS.keySet());
    }

    private static Optional<class_2487> tryGetRecordFromGen(class_2960 loc) {
        try {
            Path file = RecordRepository.getRecordPath(loc, true);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                RecordRepository.loadRecord(loc, JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                return Optional.empty();
            }
            return Optional.of(RECORDS.get(loc).method_10553());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static void subscribeResourcesReloadEvent() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("evenmoreinstruments", "burned_record_resources");
            }

            public void method_14491(class_3300 resourceManager) {
                RecordRepository.reloadRecords(resourceManager.method_14488(RecordRepository.DATA_DIR, path -> path.method_12832().endsWith(".json")));
            }
        });
    }

    private static void reloadRecords(Map<class_2960, class_3298> pObject) {
        RECORDS.clear();
        pObject.forEach((loc, tag) -> {
            JsonElement channelObj;
            try (BufferedReader reader = ((class_3298)pObject.get(loc)).method_43039();){
                channelObj = JsonParser.parseReader((Reader)reader);
            }
            catch (Exception e) {
                LOGGER.error("Met an exception upon loading burned record " + loc, (Throwable)e);
                return;
            }
            RecordRepository.loadRecord(loc, channelObj);
        });
    }

    private static void loadRecord(class_2960 loc, JsonElement channelObj) {
        RECORDS.put(RecordRepository.stripFullPath(loc), (class_2487)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, channelObj));
        LOGGER.info("Successfully loaded burned record {}", (Object)loc);
    }

    private static class_2960 stripFullPath(class_2960 loc) {
        String[] paths = loc.method_12832().split("/");
        String path = paths[paths.length - 1];
        return loc.method_45136(path.substring(0, path.lastIndexOf(46)));
    }

    public static Stream<class_2960> listRecords(boolean includeBuiltIn) {
        try {
            return Streams.concat((Stream[])new Stream[]{RecordRepository.getRecords().stream().filter(loc -> !loc.method_12836().equals("evenmoreinstruments") || includeBuiltIn), Files.list(RecordRepository.getGenPath()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(RecordRepository::listGeneratedInNamespace)}).distinct();
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static void saveRecord(class_2960 name, class_2487 channel) throws IOException {
        Path path = RecordRepository.getRecordPath(name, false);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (FileWriter outStream = new FileWriter(path.toFile());){
            JsonElement jsonData = (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)channel);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(jsonData, (Appendable)outStream);
        }
        RECORDS.put(name, channel);
    }

    public static void removeRecord(class_2960 name) throws IOException {
        Path path = RecordRepository.getRecordPath(name, true);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new class_151("Could not find resource " + name);
        }
        Files.delete(path);
        RECORDS.remove(name);
    }

    private static Path getGenPath(boolean failIfNone) throws IOException {
        Path path = MCServerInstance.get().method_27050(class_5218.field_24185).normalize();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            if (failIfNone) {
                throw new IOException("Directory not found: " + path);
            }
        } else {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    private static Path getGenPath() throws IOException {
        return RecordRepository.getGenPath(false);
    }

    private static Path getRecordPath(class_2960 name, boolean failIfNone) throws IOException {
        Path genPath = RecordRepository.getGenPath(failIfNone).resolve(name.method_12836()).resolve("evenmoreinstruments").resolve(RECORDS_DIR);
        Path path = class_4239.method_20202((Path)genPath, (String)name.method_12832(), (String)".json");
        if (!(path.startsWith(genPath) && class_4239.method_20200((Path)path) && class_4239.method_20201((Path)path))) {
            throw new class_151("Invalid resource path: " + path);
        }
        if (!Files.isRegularFile(path, new LinkOption[0]) && failIfNone) {
            throw new class_151("Could not find resource " + name);
        }
        return path;
    }

    private static Stream<class_2960> listGeneratedInNamespace(Path pPath) {
        Path path = pPath.resolve("evenmoreinstruments").resolve(RECORDS_DIR);
        return RecordRepository.listFolderContents(path, pPath.getFileName().toString(), ".json");
    }

    private static Stream<class_2960> listFolderContents(Path pFolder, String pNamespace, String pPath) {
        if (!Files.isDirectory(pFolder, new LinkOption[0])) {
            return Stream.empty();
        }
        int i = pPath.length();
        Function<String, String> function = p_230358_ -> p_230358_.substring(0, p_230358_.length() - i);
        try {
            return Files.walk(pFolder, new FileVisitOption[0]).filter(p_230381_ -> p_230381_.toString().endsWith(pPath)).mapMulti((p_230386_, p_230387_) -> {
                try {
                    p_230387_.accept(new class_2960(pNamespace, (String)function.apply(RecordRepository.relativize(pFolder, p_230386_))));
                }
                catch (class_151 resourcelocationexception) {
                    LOGGER.error("Invalid location while listing pack contents", (Throwable)resourcelocationexception);
                }
            });
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list folder contents", (Throwable)ioexception);
            return Stream.empty();
        }
    }

    private static String relativize(Path pRoot, Path pPath) {
        return pRoot.relativize(pPath).toString().replace(File.separator, "/");
    }

    static {
        RecordRepository.subscribeResourcesReloadEvent();
    }
}

