/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking;

import com.cstav.evenmoreinstruments.networking.packet.DoesLooperExistPacket;
import com.cstav.evenmoreinstruments.networking.packet.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.networking.packet.LooperRecordStatePacket;
import com.cstav.evenmoreinstruments.networking.packet.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.OpenNoteBlockInstrumentPacket;
import com.cstav.evenmoreinstruments.networking.packet.SyncModTagPacket;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;

public class EMIPacketHandler {
    private static final List<Class<IModPacket>> S2C_PACKETS = List.of(new Class[]{OpenNoteBlockInstrumentPacket.class, LooperPlayStatePacket.class, LooperUnplayablePacket.class, SyncModTagPacket.class});
    private static final List<Class<IModPacket>> C2S_PACKETS = List.of(new Class[]{LooperRecordStatePacket.class, DoesLooperExistPacket.class});

    public static void registerClientPackets() {
        for (Class<IModPacket> packetClass : S2C_PACKETS) {
            ClientPlayNetworking.registerGlobalReceiver((PacketType)IModPacket.type(packetClass), IModPacket::handle);
        }
    }

    public static void registerServerPackets() {
        for (Class<IModPacket> packetClass : C2S_PACKETS) {
            ServerPlayNetworking.registerGlobalReceiver((PacketType)IModPacket.type(packetClass), IModPacket::handle);
        }
    }

    public static void sendToServer(FabricPacket packet) {
        ClientPlayNetworking.send((FabricPacket)packet);
    }

    public static void sendToClient(FabricPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
    }
}

