/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.server.command;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class EMIRecordCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_RECORDS = (stack, builder) -> class_2172.method_9257(RecordRepository.listRecords(false), (SuggestionsBuilder)builder);
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(player -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.no_record", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_BURNED = new DynamicCommandExceptionType(player -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.record_burned", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_EMPTY = new DynamicCommandExceptionType(player -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.record_empty", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_INVALID = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.record_invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType ERROR_TOO_MANY = new DynamicCommandExceptionType(player -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.too_many", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_INVALID_NAME = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.evenmoreinstruments.emirecord.failed.invalid_name", (Object[])new Object[]{"evenmoreinstruments", id}));

    public static void register(CommandDispatcher<class_2168> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"emirecord").then(class_2170.method_9247((String)"burn").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"record", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_RECORDS).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<class_2168>)stack, (class_1657)((class_2168)stack.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).requires(stack -> stack.method_9259(2))).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<class_2168>)stack, (class_1657)class_2186.method_9315((CommandContext)stack, (String)"target"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(stack -> stack.method_9259(2))).then(class_2170.method_9244((String)"record", (ArgumentType)class_2232.method_9441()).executes(EMIRecordCommand::saveRecord)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(stack -> stack.method_9259(2))).then(class_2170.method_9244((String)"record", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_RECORDS).executes(EMIRecordCommand::removeRecord))));
    }

    private static int saveRecord(CommandContext<class_2168> stack) throws CommandSyntaxException {
        class_3222 target = ((class_2168)stack.getSource()).method_9207();
        class_2960 saveLoc = class_2232.method_9443(stack, (String)"record");
        if (saveLoc.method_12836().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAME.create((Object)saveLoc);
        }
        Optional<class_1799> record = CommonUtil.getItemInBothHands((class_1657)target, ModItems.RECORD_WRITABLE);
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.method_5476());
        }
        if (!((WritableRecordItem)record.get().method_7909()).isBurned(record.get())) {
            throw ERROR_RECORD_EMPTY.create((Object)target.method_5476());
        }
        try {
            RecordRepository.saveRecord(saveLoc, record.get().method_7941("Channel"));
        }
        catch (IOException e) {
            EMIMain.LOGGER.error("Error encountered while saving record data", (Throwable)e);
            throw new RuntimeException(e);
        }
        ((class_2168)stack.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.evenmoreinstruments.emirecord.success.record_saved"), true);
        return 1;
    }

    private static int loadRecordToHand(CommandContext<class_2168> stack, class_1657 target) throws CommandSyntaxException {
        Optional<class_1799> record = CommonUtil.getItemInBothHands(target, ModItems.RECORD_WRITABLE);
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.method_5476());
        }
        if (record.get().method_7947() > 1) {
            throw ERROR_TOO_MANY.create((Object)target.method_5476());
        }
        if (((WritableRecordItem)record.get().method_7909()).isBurned(record.get())) {
            throw ERROR_RECORD_BURNED.create((Object)target.method_5476());
        }
        class_2960 recordName = (class_2960)stack.getArgument("record", class_2960.class);
        Optional<class_2487> recordChannel = RecordRepository.getRecord(recordName);
        if (recordChannel.isEmpty()) {
            throw ERROR_RECORD_INVALID.create((Object)recordName);
        }
        record.get().method_7948().method_10582("BurnedMedia", recordName.toString());
        ((class_2168)stack.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.evenmoreinstruments.emirecord.success.record_burned"), true);
        return 1;
    }

    private static int removeRecord(CommandContext<class_2168> stack) throws CommandSyntaxException {
        class_2960 name = class_2232.method_9443(stack, (String)"record");
        if (name.method_12836().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAME.create((Object)name);
        }
        try {
            RecordRepository.removeRecord(name);
        }
        catch (Exception e) {
            throw ERROR_RECORD_INVALID.create((Object)name);
        }
        ((class_2168)stack.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.evenmoreinstruments.emirecord.success.record_removed"), true);
        return 1;
    }
}

