/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.evenmoreinstruments.util.ServerUtil;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class LooperRecordStateUtil {
    public static void handle(class_3222 player, Optional<class_1268> hand, boolean recording) {
        if (hand.isPresent()) {
            LooperRecordStateUtil.handleItem(player, hand.get(), recording);
        } else {
            LooperRecordStateUtil.handleBlock(player, recording);
        }
    }

    public static void handleBlock(class_3222 player, boolean recording) {
        class_2338 instrumentBlockPos = InstrumentEntityData.getBlockPos((class_1657)player);
        class_2586 instrumentBlock = player.method_37908().method_8321(instrumentBlockPos);
        class_2487 looperTag = LooperUtil.looperTag(instrumentBlock);
        if (looperTag.method_33133()) {
            return;
        }
        if (ServerUtil.isMaliciousPos((class_1657)player, looperTag)) {
            return;
        }
        LooperBlockEntity lbe = LooperUtil.getFromBlockInstrument(player.method_37908(), instrumentBlock);
        if (lbe == null) {
            LooperRecordStateUtil.notifyLooperUnplayable(player);
            return;
        }
        LooperRecordStateUtil.changeRecordingState(player, lbe, () -> LooperUtil.remLooperTag(instrumentBlock), recording);
        EMIPacketHandler.sendToClient((FabricPacket)new SyncModTagPacket(EMIMain.modTag(instrumentBlock), instrumentBlockPos), player);
    }

    public static void handleItem(class_3222 player, class_1268 hand, boolean recording) {
        class_1799 instrumentItem = player.method_5998(hand);
        class_2487 looperTag = LooperUtil.looperTag(instrumentItem);
        if (looperTag.method_33133()) {
            return;
        }
        if (ServerUtil.isMaliciousPos((class_1657)player, looperTag)) {
            return;
        }
        LooperBlockEntity lbe = LooperUtil.getFromItemInstrument(player.method_37908(), instrumentItem);
        if (lbe == null) {
            LooperRecordStateUtil.notifyLooperUnplayable(player);
            return;
        }
        LooperRecordStateUtil.changeRecordingState(player, lbe, () -> LooperUtil.remLooperTag(instrumentItem), recording);
    }

    public static void changeRecordingState(class_3222 player, LooperBlockEntity lbe, Runnable looperTagRemover, boolean recording) {
        if (recording) {
            if (lbe.isLocked() && !lbe.isLockedBy((class_1657)player)) {
                LooperRecordStateUtil.notifyLooperUnplayable(player);
                return;
            }
            LooperUtil.setRecording((class_1657)player, lbe.method_11016());
        } else {
            if (!lbe.isLockedBy((class_1657)player)) {
                return;
            }
            lbe.lock();
            player.method_37908().method_8501(lbe.method_11016(), lbe.setPlaying(true, lbe.method_11010()));
            looperTagRemover.run();
            LooperUtil.setNotRecording((class_1657)player);
        }
    }

    private static void notifyLooperUnplayable(class_3222 player) {
        EMIPacketHandler.sendToClient((FabricPacket)new LooperUnplayablePacket(), player);
    }
}

