/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperRecordEntityData;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class LooperUtil {
    public static final String LOOPER_TAG = "looper";
    public static final String POS_TAG = "pos";
    private static final Map<String, String> LOOPER_LEGACY_MAPPER = Map.ofEntries(Map.entry("instrumentId", "InstrumentId"), Map.entry("notes", "Notes"), Map.entry("volume", "Volume"), Map.entry("pitch", "Pitch"), Map.entry("soundIndex", "SoundIndex"), Map.entry("soundType", "SoundType"), Map.entry("timestamp", "Timestamp"), Map.entry("recording", "Recording"), Map.entry("ticks", "Ticks"), Map.entry("channel", "Channel"), Map.entry("repeatTick", "RepeatTick"));

    public static boolean hasLooperTag(class_1799 instrument) {
        return LooperUtil.hasLooperTag(EMIMain.modTag(instrument));
    }

    public static boolean hasLooperTag(class_2586 instrument) {
        return LooperUtil.hasLooperTag(EMIMain.modTag(instrument));
    }

    private static boolean hasLooperTag(class_2487 modTag) {
        return modTag.method_10573(LOOPER_TAG, 10) && !modTag.method_10562(LOOPER_TAG).method_33133();
    }

    public static void remLooperTag(class_1799 instrument) {
        EMIMain.modTag(instrument).method_10551(LOOPER_TAG);
    }

    public static void remLooperTag(class_2586 instrument) {
        EMIMain.modTag(instrument).method_10551(LOOPER_TAG);
    }

    public static void createLooperTag(class_1799 instrument, class_2338 looperPos) {
        EMIMain.modTag(instrument).method_10566(LOOPER_TAG, (class_2520)new class_2487());
        LooperUtil.constructLooperTag(LooperUtil.looperTag(instrument), looperPos);
    }

    public static void createLooperTag(class_2586 instrument, class_2338 looperPos) {
        EMIMain.modTag(instrument).method_10566(LOOPER_TAG, (class_2520)new class_2487());
        LooperUtil.constructLooperTag(LooperUtil.looperTag(instrument), looperPos);
    }

    private static void constructLooperTag(class_2487 looperTag, class_2338 looperPos) {
        looperTag.method_10566(POS_TAG, (class_2520)class_2512.method_10692((class_2338)looperPos));
    }

    public static class_2487 looperTag(class_1799 instrument) {
        return LooperUtil.looperTag(EMIMain.modTag(instrument));
    }

    public static class_2487 looperTag(class_2586 instrument) {
        return LooperUtil.looperTag(EMIMain.modTag(instrument));
    }

    public static class_2487 looperTag(class_2487 parentTag) {
        return parentTag.method_10573(LOOPER_TAG, 10) ? parentTag.method_10562(LOOPER_TAG) : new class_2487();
    }

    public static class_2487 getLooperTagFromEvent(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> args) {
        if (!args.isByPlayer()) {
            return new class_2487();
        }
        InstrumentPlayedEvent.InstrumentPlayedEventArgs.EntityInfo entityInfo = (InstrumentPlayedEvent.InstrumentPlayedEventArgs.EntityInfo)args.entityInfo().get();
        class_1657 player = (class_1657)entityInfo.entity;
        return !entityInfo.isBlockInstrument() ? LooperUtil.looperTag(player.method_5998((class_1268)entityInfo.hand.get())) : LooperUtil.looperTag(args.level().method_8321(args.soundMeta().pos()));
    }

    @Nullable
    public static LooperBlockEntity getFromEvent(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> args) {
        if (!args.isByPlayer()) {
            return null;
        }
        InstrumentPlayedEvent.InstrumentPlayedEventArgs.EntityInfo entityInfo = (InstrumentPlayedEvent.InstrumentPlayedEventArgs.EntityInfo)args.entityInfo().get();
        class_1657 player = (class_1657)entityInfo.entity;
        class_1937 level = args.level();
        if (entityInfo.isItemInstrument()) {
            return LooperUtil.getFromItemInstrument(level, player.method_5998((class_1268)entityInfo.hand.get()));
        }
        if (entityInfo.isBlockInstrument()) {
            return LooperUtil.getFromBlockInstrument(level, level.method_8321(args.soundMeta().pos()));
        }
        return null;
    }

    @Nullable
    public static LooperBlockEntity getFromItemInstrument(class_1937 level, class_1799 instrument) {
        return LooperUtil.getFromInstrument(level, LooperUtil.looperTag(instrument), () -> LooperUtil.remLooperTag(instrument));
    }

    @Nullable
    public static LooperBlockEntity getFromBlockInstrument(class_1937 level, class_2586 instrument) {
        return LooperUtil.getFromInstrument(level, LooperUtil.looperTag(instrument), () -> {
            LooperUtil.remLooperTag(instrument);
            class_2338 pos = instrument.method_11016();
            class_2680 state = level.method_8320(pos);
            class_2248 patt4816$temp = state.method_26204();
            if (patt4816$temp instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)patt4816$temp;
                LooperUtil.remLooperTag(level.method_8321(doubleBlock.getOtherBlock(state, pos, level)));
            }
        });
    }

    @Nullable
    private static LooperBlockEntity getFromInstrument(class_1937 level, class_2487 looperData, Runnable onInvalid) {
        if (looperData.method_33133()) {
            return null;
        }
        LooperBlockEntity looperBE = LooperUtil.getFromPos(level, LooperUtil.getLooperPos(looperData));
        if (looperBE == null) {
            onInvalid.run();
        }
        return looperBE;
    }

    public static LooperBlockEntity getFromPos(class_1937 level, class_2338 pos) {
        LooperBlockEntity lbe;
        class_2586 class_25862 = level.method_8321(pos);
        return class_25862 instanceof LooperBlockEntity ? (lbe = (LooperBlockEntity)class_25862) : null;
    }

    public static boolean performPair(LooperBlockEntity lbe, Runnable pairPerformer, class_1657 pairingPlayer) {
        if (!LooperUtil.validateFootagePresence(lbe, pairingPlayer)) {
            return false;
        }
        pairPerformer.run();
        pairingPlayer.method_7353((class_2561)class_2561.method_43471((String)"item.evenmoreinstruments.looper_adapter.instrument.success_pair").method_27692(class_124.field_1060), true);
        return true;
    }

    public static boolean validateFootagePresence(LooperBlockEntity lbe, class_1657 pairingPlayer) {
        if (!lbe.hasFootage()) {
            return true;
        }
        pairingPlayer.method_7353((class_2561)class_2561.method_43471((String)"evenmoreinstruments.looper.pair_conflict").method_27692(class_124.field_1060), true);
        return false;
    }

    public static boolean isSameBlock(class_2487 looperTag, class_2338 pos) {
        try {
            return LooperUtil.getLooperPos(looperTag).equals((Object)pos);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    public static class_2338 getLooperPos(class_2487 looperTag) {
        class_2487 looperPosTag = looperTag.method_10562(POS_TAG);
        return looperPosTag == null ? null : class_2512.method_10691((class_2487)looperPosTag);
    }

    public static void setRecording(class_1657 player, class_2338 looperPos) {
        LooperRecordEntityData.setRecording((class_1297)player, looperPos);
    }

    public static void setNotRecording(class_1657 player) {
        LooperRecordEntityData.setNotRecording((class_1297)player);
    }

    public static boolean isRecording(class_1657 player) {
        return LooperRecordEntityData.isRecording((class_1297)player);
    }

    public static Optional<class_2487> migrateLegacyLooper(LooperBlockEntity lbe) {
        class_2487 lbed = lbe.getPersistentData();
        if (!lbed.method_10573("channel", 10)) {
            return Optional.empty();
        }
        class_2487 looperData = CommonUtil.deepConvertCompound(lbed, LOOPER_LEGACY_MAPPER);
        class_2487 channel = looperData.method_10562("Channel");
        looperData.method_10556("Writable", false);
        CommonUtil.moveTags(looperData, channel, "RepeatTick");
        lbed.method_10541().stream().toList().forEach(arg_0 -> ((class_2487)lbed).method_10551(arg_0));
        looperData.method_10541().stream().filter(key -> !key.equals("Channel")).forEach(key -> lbed.method_10566(key, looperData.method_10580(key)));
        return Optional.of(channel);
    }
}

