/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.recipe.RecipeUtils;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;

public class DyeCauldronBlock
extends ModCauldronBlock {
    public static final class_2758 LEVEL = class_2741.field_12513;

    public DyeCauldronBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public class_2758 getLevelProperty() {
        return LEVEL;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 3;
    }

    protected boolean method_32765(class_3611 fluid) {
        return false;
    }

    protected double method_31615(class_2680 state) {
        return (6.0 + (double)((Integer)state.method_11654((class_2769)LEVEL)).intValue() * 3.0) / 16.0;
    }

    protected void method_32764(class_2680 state, class_1937 level, class_2338 pos, class_3611 fluid) {
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            if (te.handleInteraction(player, hand)) {
                return class_1269.method_29236((boolean)level.field_9236);
            }
            if (!CommonConfigs.CAULDRON_CRAFTING.get().booleanValue()) {
                return class_1269.field_5811;
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            SoftFluidStack fluid = tank.getFluid();
            if (fluid.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                class_1799 stack = player.method_5998(hand);
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1769) {
                    class_1769 di = (class_1769)class_17922;
                    return DyeCauldronBlock.addDye(level, te, stack, player, di);
                }
                Pair<class_1799, Float> crafted = RecipeUtils.craftWithFluidAndDye(level, tank.getFluid(), stack);
                if (crafted != null && this.doCraftItem(level, pos, player, hand, fluid, stack, (class_1799)crafted.getFirst(), ((Float)crafted.getSecond()).floatValue(), CommonConfigs.DYE_RECIPES_PER_LAYER.get())) {
                    te.method_5431();
                    return class_1269.method_29236((boolean)level.field_9236);
                }
            }
        }
        return class_1269.field_5811;
    }

    @Override
    protected void handleEntityInside(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1472) {
            LiquidCauldronBlockTile te;
            SoftFluidStack fluid;
            class_1472 sheep = (class_1472)entity;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof LiquidCauldronBlockTile && (fluid = (te = (LiquidCauldronBlockTile)class_25862).getSoftFluidTank().getFluid()).is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                class_1767 dye = DyeBottleItem.getClosestDye(fluid);
                if (sheep.method_6633() != dye) {
                    sheep.method_6631(dye);
                    te.consumeOneLayer();
                    level.method_33596(entity, class_5712.field_28733, pos);
                }
            }
        }
    }

    @Override
    public class_2680 updateStateOnFluidChange(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        int height = fluid.getCount();
        state = fluid.isEmpty() ? class_2246.field_10593.method_9564() : (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(height));
        return state;
    }

    public static void playDyeSoundAndConsume(class_2680 state, class_2338 pos, class_1937 level, class_1657 player, class_1799 stack) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            class_174.field_24478.method_23889(serverPlayer, pos, stack);
        }
        level.method_8396(player, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
        level.method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.3f);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
    }

    public static class_1269 addDye(class_1937 level, LiquidCauldronBlockTile tile, class_1799 stack, class_1657 player, class_1769 dyeItem) {
        SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
        if (!level.method_8608()) {
            int count = fluid.getCount();
            if (count == 3) {
                fluid.setCount(2);
            }
            SoftFluidStack dummyStack = DyeBottleItem.toFluidStack(dyeItem.method_7802(), 1);
            LiquidMixer.mixDye(fluid, dummyStack);
            fluid.setCount(count);
            tile.method_5431();
        }
        DyeCauldronBlock.playDyeSoundAndConsume(tile.method_11010(), tile.method_11016(), level, player, stack);
        return class_1269.method_29236((boolean)level.field_9236);
    }
}

