/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.integration;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.vanilla.BellInstance;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.IBellConnection;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.minecraft.class_2591;
import net.minecraft.class_3721;
import org.jetbrains.annotations.Nullable;

public class FlywheelCompat {
    public static final PartialModel BELL_CHAIN = new PartialModel(AmendmentsClient.BELL_CHAIN);
    public static final PartialModel BELL_ROPE = new PartialModel(AmendmentsClient.BELL_ROPE);

    public static void init() {
        InstancedRenderRegistry.configure((class_2591)class_2591.field_16413).alwaysSkipRender().factory(AmendmentsBellInstance::new).apply();
    }

    public static class AmendmentsBellInstance
    extends BellInstance {
        @Nullable
        private OrientedData connection;
        private IBellConnection.Type type;

        public AmendmentsBellInstance(MaterialManager materialManager, class_3721 blockEntity) {
            super(materialManager, blockEntity);
            this.type = ((IBellConnection)blockEntity).amendments$getConnection();
            this.connection = this.updateConnection();
        }

        private OrientedData updateConnection() {
            if (this.type == IBellConnection.Type.NONE || !ClientConfigs.BELL_CONNECTION.get().booleanValue()) {
                return null;
            }
            if (this.type == IBellConnection.Type.ROPE) {
                return ((OrientedData)this.getOrientedMaterial().getModel(BELL_ROPE, this.blockState).createInstance()).setPosition(this.getInstancePosition());
            }
            if (this.type == IBellConnection.Type.CHAIN) {
                return ((OrientedData)this.getOrientedMaterial().getModel(BELL_CHAIN, this.blockState).createInstance()).setPosition(this.getInstancePosition());
            }
            return null;
        }

        public boolean shouldReset() {
            return super.shouldReset() || this.type != ((IBellConnection)this.blockEntity).amendments$getConnection();
        }

        public void beginFrame() {
            IBellConnection.Type type = ((IBellConnection)this.blockEntity).amendments$getConnection();
            if (type != this.type) {
                this.type = type;
                if (this.connection != null) {
                    this.connection.delete();
                }
                this.connection = this.updateConnection();
                this.updateLight();
            }
            super.beginFrame();
        }

        public void updateLight() {
            if (this.connection != null) {
                this.relight(this.getWorldPosition(), new FlatLit[]{this.connection});
            }
            super.updateLight();
        }

        public void remove() {
            super.remove();
            if (this.connection != null) {
                this.connection.delete();
            }
        }
    }
}

