/*
 * Decompiled with CFR 0.152.
 */
package ripio.lootballs.block.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import ripio.lootballs.block.LootBallsBlockEntities;
import ripio.lootballs.block.entity.ImplementedInventory;

public class LootBallEntity
extends class_2586
implements ImplementedInventory,
class_1278 {
    private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public static final String LOOT_TABLE_KEY = "LootTable";
    public static final String LOOT_TABLE_SEED_KEY = "LootTableSeed";
    public static final String USES_KEY = "Uses";
    public static final String OPENERS_KEY = "Openers";
    public static final String INFINITE_KEY = "Infinite";
    public static final String MULTIPLIER_KEY = "Multiplier";
    @Nullable
    protected class_2960 lootTableId;
    protected long lootTableSeed;
    protected int uses = 1;
    protected Set<UUID> openers = new HashSet<UUID>();
    protected boolean infinite = false;
    protected float multiplier = 1.0f;
    protected boolean renewLoot = true;

    public LootBallEntity(class_2338 pos, class_2680 state, float multiplier, int uses) {
        super(LootBallsBlockEntities.LOOT_BALL_ENTITY, pos, state);
        this.multiplier = multiplier;
        this.uses = uses;
    }

    public LootBallEntity(class_2338 pos, class_2680 state) {
        super(LootBallsBlockEntities.LOOT_BALL_ENTITY, pos, state);
    }

    public static void setLootTable(class_1922 world, class_5819 random, class_2338 pos, class_2960 id) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootBallEntity) {
            ((LootBallEntity)blockEntity).setLootTable(id, random.method_43055());
        }
    }

    public void setLootTable(class_2960 id, long seed) {
        this.lootTableId = id;
        this.lootTableSeed = seed;
        this.method_5431();
    }

    protected void deserializeLootTable(class_2487 nbt) {
        if (nbt.method_10573(LOOT_TABLE_KEY, 8)) {
            this.lootTableId = new class_2960(nbt.method_10558(LOOT_TABLE_KEY));
            this.lootTableSeed = nbt.method_10537(LOOT_TABLE_SEED_KEY);
        }
    }

    protected void serializeLootTable(class_2487 nbt) {
        if (this.lootTableId == null) {
            return;
        }
        nbt.method_10582(LOOT_TABLE_KEY, this.lootTableId.toString());
        if (this.lootTableSeed != 0L) {
            nbt.method_10544(LOOT_TABLE_SEED_KEY, this.lootTableSeed);
        }
    }

    public void addOpener(UUID uuid) {
        this.openers.add(uuid);
        this.method_5431();
    }

    public boolean isOpener(UUID uuid) {
        return this.openers.contains(uuid);
    }

    protected void serializeOpeners(class_2487 nbt) {
        if (this.openers.isEmpty()) {
            return;
        }
        class_2499 nbtList = new class_2499();
        for (UUID opener : this.openers) {
            nbtList.add((Object)class_2519.method_23256((String)opener.toString()));
        }
        nbt.method_10566(OPENERS_KEY, (class_2520)nbtList);
    }

    protected void deserializeOpeners(class_2487 nbt) {
        block3: {
            String[] uuidStrings;
            block2: {
                if (!nbt.method_10573(OPENERS_KEY, 9)) break block2;
                class_2499 nbtList = nbt.method_10554(OPENERS_KEY, 8);
                for (class_2520 strUUID : nbtList) {
                    this.addOpener(UUID.fromString(strUUID.method_10714()));
                }
                break block3;
            }
            if (!nbt.method_10573(OPENERS_KEY, 8)) break block3;
            for (String strUUID : uuidStrings = nbt.method_10558(OPENERS_KEY).split(",")) {
                this.addOpener(UUID.fromString(strUUID));
            }
        }
    }

    public void setUses(int uses) {
        if (!this.infinite) {
            this.uses = uses;
            this.method_5431();
        }
    }

    public int getUses() {
        return this.uses;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void checkLootInteraction(@Nullable class_1657 player) {
        if (this.lootTableId != null && this.field_11863 != null && this.field_11863.method_8503() != null && this.renewLoot && player != null) {
            this.renewLoot = false;
            if (!this.method_5442()) {
                return;
            }
            if (this.isOpener(player.method_5667())) {
                return;
            }
            class_52 lootTable = this.field_11863.method_8503().method_3857().getLootTable(this.lootTableId);
            if (player instanceof class_3222) {
                class_174.field_24479.method_27993((class_3222)player, this.lootTableId);
            }
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.field_11863).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867));
            builder.method_51871(player.method_7292()).method_51874(class_181.field_1226, (Object)player);
            lootTable.method_329((class_1263)this, builder.method_51875(class_173.field_1179), this.lootTableSeed);
            this.method_5431();
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.items);
        this.deserializeLootTable(nbt);
        this.deserializeOpeners(nbt);
        if (nbt.method_10573(USES_KEY, 3)) {
            this.uses = nbt.method_10550(USES_KEY);
        }
        if (nbt.method_10573(INFINITE_KEY, 1)) {
            this.infinite = nbt.method_10577(INFINITE_KEY);
        }
        if (nbt.method_10573(MULTIPLIER_KEY, 5)) {
            this.multiplier = nbt.method_10583(MULTIPLIER_KEY);
        }
    }

    public void method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.items);
        this.serializeLootTable(nbt);
        this.serializeOpeners(nbt);
        nbt.method_10569(USES_KEY, this.uses);
        nbt.method_10556(INFINITE_KEY, this.infinite);
        nbt.method_10548(MULTIPLIER_KEY, this.multiplier);
        super.method_11007(nbt);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        return false;
    }

    public class_1799 copyStack(int slot) {
        return ((class_1799)this.items.get(slot)).method_7972();
    }

    public void regenerateLoot(long lootTableSeed) {
        if (this.lootTableId != null) {
            this.method_5448();
            this.renewLoot = true;
            this.lootTableSeed = lootTableSeed;
        }
    }
}

