/*
 * Decompiled with CFR 0.152.
 */
package ripio.lootballs.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;
import ripio.lootballs.data.LootBallsBiomeTags;
import ripio.lootballs.datagen.LootBallsBlockTagProvider;

public class LootBallsUtils {
    public static int COMMON_WEIGHT = 80;
    public static int UNCOMMON_WEIGHT = 30;
    public static int RARE_WEIGHT = 12;
    public static int ULTRA_RARE_WEIGHT = 1;
    public static int TOTAL_WEIGHT = COMMON_WEIGHT + UNCOMMON_WEIGHT + RARE_WEIGHT + ULTRA_RARE_WEIGHT;
    private static final class_2960[] COMMON_LOOTS = new class_2960[]{new class_2960("lootballs", "poke_loot_ball"), new class_2960("lootballs", "safari_loot_ball")};
    private static final class_2960[] UNCOMMON_LOOTS = new class_2960[]{new class_2960("lootballs", "dive_loot_ball"), new class_2960("lootballs", "great_loot_ball"), new class_2960("lootballs", "heal_loot_ball")};
    private static final class_2960[] RARE_LOOTS = new class_2960[]{new class_2960("lootballs", "ultra_loot_ball")};
    private static final class_2960[] ULTRA_RARE_LOOTS = new class_2960[]{new class_2960("lootballs", "master_loot_ball")};
    private static final class_2960[] POKE_LOOT_EQUIVALENTS = new class_2960[]{new class_2960("lootballs", "poke_loot_ball"), new class_2960("lootballs", "azure_loot_ball"), new class_2960("lootballs", "citrine_loot_ball"), new class_2960("lootballs", "premier_loot_ball"), new class_2960("lootballs", "roseate_loot_ball"), new class_2960("lootballs", "slate_loot_ball"), new class_2960("lootballs", "verdant_loot_ball")};

    @Nullable
    public static class_2960 randomLootBall(class_5819 random, class_6880<class_1959> biomeRegistryEntryFilter) {
        int randint = random.method_43048(TOTAL_WEIGHT);
        if (randint < COMMON_WEIGHT) {
            return LootBallsUtils.filteredLootBall(COMMON_LOOTS, biomeRegistryEntryFilter, random);
        }
        if (randint < COMMON_WEIGHT + UNCOMMON_WEIGHT) {
            return LootBallsUtils.filteredLootBall(UNCOMMON_LOOTS, biomeRegistryEntryFilter, random);
        }
        if (randint < COMMON_WEIGHT + UNCOMMON_WEIGHT + RARE_WEIGHT) {
            return LootBallsUtils.filteredLootBall(RARE_LOOTS, biomeRegistryEntryFilter, random);
        }
        return LootBallsUtils.filteredLootBall(ULTRA_RARE_LOOTS, biomeRegistryEntryFilter, random);
    }

    @Nullable
    public static class_2960 getLootBallLootTable(class_2960 identifier) {
        if (identifier == null) {
            return null;
        }
        String path = identifier.method_12832().split("_")[0] + "_loot_table";
        return new class_2960("lootballs", path);
    }

    public static class_6862<class_1959> getLootBallBiomeTags(class_2960 blockId, class_6880<class_1959> biome) {
        String path = blockId.method_12832();
        if (Objects.equals(path, "safari_loot_ball")) {
            return LootBallsBiomeTags.HAS_LOOTBALL_SAFARI;
        }
        if (Objects.equals(path, "heal_loot_ball")) {
            return LootBallsBiomeTags.HAS_LOOTBALL_HEAL;
        }
        if (Objects.equals(path, "dive_loot_ball")) {
            return class_6908.field_36509;
        }
        if (biome.method_40220(class_6908.field_37394)) {
            return class_6908.field_37394;
        }
        if (biome.method_40220(class_6908.field_36518)) {
            return class_6908.field_36518;
        }
        return LootBallsBiomeTags.IS_OVERWORLD;
    }

    public static class_6862<class_2248>[] getLootBallBlockTags(class_2960 blockId) {
        String path = blockId.method_12832();
        ArrayList<class_6862<class_2248>> tagsList = new ArrayList<class_6862<class_2248>>();
        tagsList.add(LootBallsBlockTagProvider.LOOT_BALLS_BASE_BLOCKS);
        return tagsList.toArray(new class_6862[0]);
    }

    public static List<Integer> getLootBallHeightRange(class_2960 blockId, class_5281 world) {
        String path = blockId.method_12832();
        if (Objects.equals(path, "dive_loot_ball")) {
            return List.of(Integer.valueOf(0), Integer.valueOf(40));
        }
        return List.of(Integer.valueOf(world.method_31607()), Integer.valueOf(world.method_31600()));
    }

    @Nullable
    private static class_2960 filteredLootBall(class_2960[] identifiers, class_6880<class_1959> biome, class_5819 random) {
        ArrayList<class_2960> filteredLoots = new ArrayList<class_2960>();
        for (class_2960 identifier : identifiers) {
            if (!biome.method_40220(LootBallsUtils.getLootBallBiomeTags(identifier, biome))) continue;
            filteredLoots.add(identifier);
        }
        ArrayList copyLoots = new ArrayList(filteredLoots);
        for (class_2960 identifier : copyLoots) {
            if (!Objects.equals(identifier.method_12832(), "poke_loot_ball")) continue;
            filteredLoots.remove(identifier);
            filteredLoots.add(POKE_LOOT_EQUIVALENTS[random.method_43048(POKE_LOOT_EQUIVALENTS.length)]);
            break;
        }
        if (filteredLoots.isEmpty()) {
            return null;
        }
        return (class_2960)filteredLoots.get(random.method_43048(filteredLoots.size()));
    }
}

