/*
 * Decompiled with CFR 0.152.
 */
package ripio.lootballs.world.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import ripio.lootballs.LootBalls;
import ripio.lootballs.block.custom.LootBallBlock;
import ripio.lootballs.block.entity.LootBallEntity;
import ripio.lootballs.datagen.LootBallsBlockTagProvider;
import ripio.lootballs.util.LootBallsUtils;
import ripio.lootballs.world.LootBallsGamerules;
import ripio.lootballs.world.feature.LootBallFeatureConfig;

public class LootBallFeature
extends class_3031<LootBallFeatureConfig> {
    public LootBallFeature(Codec<LootBallFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<LootBallFeatureConfig> context) {
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        class_5281 world = context.method_33652();
        LootBallFeatureConfig config = (LootBallFeatureConfig)context.method_33656();
        if (world.method_8503() != null) {
            if (!world.method_8503().method_3767().method_8355(LootBallsGamerules.GENERATE_LOOT_BALLS)) {
                return false;
            }
            int placements = random.method_39332(LootBalls.CONFIG.minLootBallsPerChunk(), LootBalls.CONFIG.maxLootBallsPerChunk());
            for (int i = 0; i < placements; ++i) {
                this.placeLootBall(world, origin, random, config);
            }
            return true;
        }
        return false;
    }

    private void placeLootBall(class_5281 world, class_2338 origin, class_5819 random, LootBallFeatureConfig config) {
        if (random.method_43057() > LootBalls.CONFIG.generationChance()) {
            return;
        }
        class_2960 blockId = LootBallsUtils.randomLootBall(random, (class_6880<class_1959>)world.method_23753(origin));
        if (blockId == null) {
            return;
        }
        class_2960 lootTableId = LootBallsUtils.getLootBallLootTable(blockId);
        if (lootTableId == null) {
            return;
        }
        class_6862<class_1959> biomeTag = LootBallsUtils.getLootBallBiomeTags(blockId, (class_6880<class_1959>)world.method_23753(origin));
        class_6862<class_2248>[] blockTags = LootBallsUtils.getLootBallBlockTags(blockId);
        List<Integer> heightRange = LootBallsUtils.getLootBallHeightRange(blockId, world);
        class_2338 testPos = origin.method_10069(random.method_39332(0, 15), random.method_39332(heightRange.get(0).intValue(), heightRange.get(1).intValue()), random.method_39332(0, 15));
        for (int y = testPos.method_10264(); y > heightRange.get(0); --y) {
            class_2680 floorState;
            if ((testPos = testPos.method_10074()).method_10264() <= heightRange.get(0) || testPos.method_10264() >= heightRange.get(1)) {
                return;
            }
            if (!world.method_23753(testPos).method_40220(biomeTag) || !this.blockOf(floorState = world.method_8320(testPos.method_10074()), blockTags) || !world.method_8320(testPos).method_26164(LootBallsBlockTagProvider.LOOT_BALLS_REPLACEABLES)) continue;
            class_2680 ballState = ((LootBallBlock)((Object)class_7923.field_41175.method_10223(blockId))).getGenerationState(random, testPos, world);
            if (ballState == null) {
                throw new IllegalStateException(blockId + "could could not be parsed to a valid block identifier!");
            }
            world.method_8652(testPos, ballState, 2);
            LootBallEntity.setLootTable((class_1922)world, random, testPos, lootTableId);
            return;
        }
    }

    private boolean blockOf(class_2680 floorState, class_6862<class_2248>[] tagKeys) {
        for (class_6862<class_2248> tagKey : tagKeys) {
            if (!floorState.method_26164(tagKey)) continue;
            return true;
        }
        return false;
    }
}

