/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.client.ICrosshairRenderer;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.DynamicPickContext;
import com.github.exopandora.shouldersurfing.api.model.ObstructionPickContext;
import com.github.exopandora.shouldersurfing.api.model.OffsetPickContext;
import com.github.exopandora.shouldersurfing.api.model.PickOrigin;
import com.github.exopandora.shouldersurfing.api.model.PickVector;
import com.github.exopandora.shouldersurfing.api.util.EntityHelper;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_4184;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PickContext {
    private final class_4184 camera;
    private final class_3959.class_242 fluidContext;
    private final class_1297 entity;

    protected PickContext(class_4184 camera, class_3959.class_242 fluidContext, class_1297 entity) {
        this.camera = camera;
        this.fluidContext = fluidContext;
        this.entity = entity;
    }

    public abstract class_3959.class_3960 blockContext();

    public abstract Couple<class_243> entityTrace(double var1, float var3);

    public abstract Couple<class_243> blockTrace(double var1, float var3);

    public class_3959 toClipContext(double interactionRange, float partialTick) {
        Couple<class_243> blockTrace = this.blockTrace(interactionRange, partialTick);
        return new class_3959(blockTrace.left(), blockTrace.right(), this.blockContext(), this.fluidContext(), this.entity());
    }

    public class_4184 camera() {
        return this.camera;
    }

    public class_3959.class_242 fluidContext() {
        return this.fluidContext;
    }

    public class_1297 entity() {
        return this.entity;
    }

    public static class Builder {
        private final class_4184 camera;
        private class_3959.class_242 fluidContext;
        private class_1297 entity;
        private Boolean offsetTrace = null;
        private class_243 endPos;
        private PickOrigin entityPickOrigin;
        private PickOrigin blockPickOrigin;
        private PickVector pickVector;

        public Builder(class_4184 camera) {
            this.camera = camera;
        }

        public Builder withFluidContext(class_3959.class_242 fluidContext) {
            this.fluidContext = fluidContext;
            return this;
        }

        public Builder withEntity(class_1297 entity) {
            this.entity = entity;
            return this;
        }

        public Builder withEntityPickOrigin(PickOrigin entityPickOrigin) {
            this.entityPickOrigin = entityPickOrigin;
            return this;
        }

        public Builder withBlockPickOrigin(PickOrigin blockPickOrigin) {
            this.blockPickOrigin = blockPickOrigin;
            return this;
        }

        public Builder withPickVector(PickVector pickVector) {
            this.pickVector = pickVector;
            return this;
        }

        public Builder dynamicTrace() {
            this.offsetTrace = false;
            return this;
        }

        public Builder offsetTrace() {
            this.offsetTrace = true;
            return this;
        }

        public Builder obstructionTrace(class_243 endPos) {
            this.endPos = endPos;
            return this;
        }

        public PickContext build() {
            class_3959.class_242 fluidContext;
            class_1297 entity = this.entity == null ? class_310.method_1551().method_1560() : this.entity;
            class_3959.class_242 class_2422 = fluidContext = this.fluidContext == null ? class_3959.class_242.field_1348 : this.fluidContext;
            if (EntityHelper.isPlayerSpectatingEntity()) {
                return new DynamicPickContext(this.camera, fluidContext, class_310.method_1551().method_1560(), PickVector.PLAYER);
            }
            if (this.endPos != null) {
                return new ObstructionPickContext(this.camera, fluidContext, entity, this.endPos);
            }
            ICrosshairRenderer crosshairRenderer = ShoulderSurfing.getInstance().getCrosshairRenderer();
            boolean offsetTrace = this.offsetTrace == null ? !crosshairRenderer.isCrosshairDynamic(entity) : this.offsetTrace;
            IClientConfig config = ShoulderSurfing.getInstance().getClientConfig();
            if (offsetTrace) {
                PickOrigin blockPickOrigin = this.blockPickOrigin == null ? config.getBlockPickOrigin() : this.blockPickOrigin;
                PickOrigin entityPickOrigin = this.entityPickOrigin == null ? config.getEntityPickOrigin() : this.entityPickOrigin;
                return new OffsetPickContext(this.camera, fluidContext, entity, blockPickOrigin, entityPickOrigin);
            }
            PickVector pickVector = this.pickVector == null ? config.getPickVector() : this.pickVector;
            return new DynamicPickContext(this.camera, fluidContext, entity, pickVector);
        }
    }
}

