/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(class_1297 entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        if (this.shouldRenderCameraEntityTransparent(entity)) {
            class_243 renderOffset = this.instance.getCamera().getRenderOffset();
            float xAlpha = (float)class_3532.method_15350((double)(Math.abs(renderOffset.method_10216()) / ((double)entity.method_17681() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (renderOffset.method_10214() > 0.0) {
                yAlpha = (float)class_3532.method_15350((double)(renderOffset.method_10214() / (double)(entity.method_17682() - entity.method_5751())), (double)0.0, (double)1.0);
            } else if (renderOffset.method_10214() < 0.0) {
                yAlpha = (float)class_3532.method_15350((double)(-renderOffset.method_10214() / (double)(-entity.method_5751())), (double)0.0, (double)1.0);
            }
            this.cameraEntityAlpha = class_3532.method_15363((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        }
        return false;
    }

    public void postRenderCameraEntity(class_1297 entity, float partialTick) {
        this.cameraEntityAlpha = 1.0f;
    }

    private boolean shouldSkipCameraEntityRendering(class_1297 cameraEntity) {
        class_1657 player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.method_7325() && (camera.getCameraDistance() < (double)cameraEntity.method_17681() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof class_1657 && (player = (class_1657)cameraEntity).method_31550());
    }

    private boolean shouldRenderCameraEntityTransparent(class_1297 entity) {
        class_243 renderOffset = this.instance.getCamera().getRenderOffset();
        return this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled() && !entity.method_7325() && Math.abs(renderOffset.method_10216()) < (double)entity.method_17681() / 2.0 && (renderOffset.method_10214() >= 0.0 && renderOffset.method_10214() < (double)(entity.method_17682() - entity.method_5751()) || renderOffset.method_10214() <= 0.0 && -renderOffset.method_10214() < (double)entity.method_5751());
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }
}

