/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ITargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.api.util.EntityHelper;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1922;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ShoulderSurfingCamera
implements IShoulderSurfingCamera {
    private static final Vector3f VECTOR_NEGATIVE_Y = new Vector3f(0.0f, -1.0f, 0.0f);
    private final ShoulderSurfingImpl instance;
    private class_243 offset;
    private class_243 offsetO;
    private class_243 renderOffset;
    private class_243 targetOffset;
    private double cameraDistance;
    private double maxCameraDistance;
    private double maxCameraDistanceO;
    private float xRot;
    private float yRot;
    private float xRotOffset;
    private float yRotOffset;
    private float xRotOffsetO;
    private float yRotOffsetO;
    private float freeLookYRot;
    private float lastMovedYRot;
    private boolean initialized;

    public ShoulderSurfingCamera(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    public void tick() {
        class_1297 class_12972;
        if (!this.initialized) {
            this.init();
        }
        double cameraTransitionSpeedMultiplier = Config.CLIENT.getCameraTransitionSpeedMultiplier();
        this.xRotOffsetO = this.xRotOffset;
        this.yRotOffsetO = this.yRotOffset;
        this.offsetO = this.offset;
        this.offset = this.offsetO.method_35590(this.targetOffset, cameraTransitionSpeedMultiplier);
        this.maxCameraDistanceO = this.maxCameraDistance;
        this.maxCameraDistance += (this.offset.method_1033() - this.maxCameraDistance) * cameraTransitionSpeedMultiplier;
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (Config.CLIENT.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof class_1309) {
                class_1309 living = (class_1309)cameraEntity;
                this.xRot += living.method_36455() - living.field_6004;
                this.yRot += living.method_5791() - living.field_6259;
            }
        } else if (cameraEntity != null && cameraEntity.method_5765() && (class_12972 = cameraEntity.method_5854()) instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            this.yRot += boat.method_36454() - boat.field_5982;
        }
        if (!this.instance.isFreeLooking()) {
            this.freeLookYRot = this.yRot;
            this.xRotOffset *= 0.5f;
            this.yRotOffset *= 0.5f;
        }
    }

    private void init() {
        this.offsetO = this.offset = new class_243(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        this.renderOffset = this.offset;
        this.targetOffset = this.offset;
        this.maxCameraDistanceO = this.maxCameraDistance = this.offset.method_1033();
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity != null) {
            this.xRot = cameraEntity.method_36455();
            this.yRot = cameraEntity.method_36454();
        } else {
            this.xRot = 0.0f;
            this.yRot = -180.0f;
        }
        this.xRotOffset = 0.0f;
        this.yRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
        this.yRotOffsetO = 0.0f;
        this.lastMovedYRot = this.yRot;
        this.initialized = true;
    }

    public Vec2f calcRotations(class_1297 cameraEntity, float partialTick) {
        class_1297 class_12972;
        if (!Config.CLIENT.isCameraDecoupled() && EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof class_1309) {
            class_1309 living = (class_1309)cameraEntity;
            return new Vec2f(living.method_5695(partialTick), living.method_5705(partialTick));
        }
        float cameraXRotWithOffset = class_3532.method_15363((float)(class_3532.method_17821((float)partialTick, (float)this.xRotOffsetO, (float)this.xRotOffset) + this.xRot), (float)-90.0f, (float)90.0f);
        float cameraYRotWithOffset = class_3532.method_17821((float)partialTick, (float)this.yRotOffsetO, (float)this.yRotOffset) + this.yRot;
        if (Config.CLIENT.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof class_1309) {
                class_1309 living = (class_1309)cameraEntity;
                cameraXRotWithOffset += (living.method_36455() - living.field_6004) * partialTick;
                cameraYRotWithOffset += (living.method_5791() - living.field_6259) * partialTick;
            }
        } else if (cameraEntity != null && !Config.CLIENT.isCameraDecoupled() && cameraEntity.method_5765() && (class_12972 = cameraEntity.method_5854()) instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            cameraYRotWithOffset += (boat.method_36454() - boat.field_5982) * partialTick;
        }
        return new Vec2f(cameraXRotWithOffset, cameraYRotWithOffset);
    }

    public class_243 calcOffset(class_4184 camera, class_1922 level, float partialTick, class_1297 cameraEntity) {
        class_1309 living;
        class_243 defaultOffset;
        class_243 targetOffset = defaultOffset = new class_243(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        List<ITargetCameraOffsetCallback> targetCameraOffsetCallbacks = ShoulderSurfingRegistrar.getInstance().getTargetCameraOffsetCallbacks();
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.pre(this.instance, targetOffset, defaultOffset);
        }
        if (cameraEntity.method_5765()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getPassengerOffsetModifiers(), Config.CLIENT.getPassengerOffsetMultipliers());
        }
        if (cameraEntity.method_5624()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getSprintOffsetModifiers(), Config.CLIENT.getSprintOffsetMultipliers());
        }
        if (this.instance.isAiming()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getAimingOffsetModifiers(), Config.CLIENT.getAimingOffsetMultipliers());
        }
        if (cameraEntity instanceof class_1309 && (living = (class_1309)cameraEntity).method_6128()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getFallFlyingOffsetModifiers(), Config.CLIENT.getFallFlyingMultipliers());
        }
        if (!cameraEntity.method_7325()) {
            if (cameraEntity instanceof class_1309 && (living = (class_1309)cameraEntity).method_6101()) {
                targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getClimbingOffsetModifiers(), Config.CLIENT.getClimbingMultipliers());
            }
            if ((double)camera.method_19335().angle((Vector3fc)VECTOR_NEGATIVE_Y) < Config.CLIENT.getCenterCameraWhenLookingDownAngle() * 0.01745329238474369) {
                targetOffset = new class_243(0.0, 0.0, targetOffset.method_10215());
            }
            if (Config.CLIENT.doDynamicallyAdjustOffsets()) {
                targetOffset = ShoulderSurfingCamera.calcDynamicOffsets(camera, cameraEntity, level, targetOffset);
            }
        }
        double targetOffsetX = Config.CLIENT.isUnlimitedOffsetX() ? targetOffset.method_10216() : class_3532.method_15350((double)targetOffset.method_10216(), (double)Config.CLIENT.getMinOffsetX(), (double)Config.CLIENT.getMaxOffsetX());
        double targetOffsetY = Config.CLIENT.isUnlimitedOffsetY() ? targetOffset.method_10214() : class_3532.method_15350((double)targetOffset.method_10214(), (double)Config.CLIENT.getMinOffsetY(), (double)Config.CLIENT.getMaxOffsetY());
        double targetOffsetZ = Config.CLIENT.isUnlimitedOffsetZ() ? targetOffset.method_10215() : class_3532.method_15350((double)targetOffset.method_10215(), (double)Config.CLIENT.getMinOffsetZ(), (double)Config.CLIENT.getMaxOffsetZ());
        targetOffset = new class_243(targetOffsetX, targetOffsetY, targetOffsetZ);
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.post(this.instance, targetOffset, defaultOffset);
        }
        this.targetOffset = targetOffset;
        class_243 lerpedOffset = this.offsetO.method_35590(this.offset, (double)partialTick);
        if (cameraEntity.method_7325()) {
            this.cameraDistance = lerpedOffset.method_1033();
            this.renderOffset = lerpedOffset;
        } else {
            double targetCameraDistance = ShoulderSurfingCamera.maxZoom(camera, level, lerpedOffset, partialTick);
            if (targetCameraDistance < this.maxCameraDistance) {
                this.maxCameraDistance = targetCameraDistance;
            }
            double lerpedMaxDistance = class_3532.method_16436((double)partialTick, (double)this.maxCameraDistanceO, (double)this.maxCameraDistance);
            this.cameraDistance = Math.min(targetCameraDistance, lerpedMaxDistance);
            this.renderOffset = lerpedOffset.method_1029().method_1021(this.cameraDistance);
        }
        return this.renderOffset;
    }

    private static class_243 applyModifiersAndMultipliers(class_243 targetVec, class_243 originalVec, class_243 modifiers, class_243 multipliers) {
        return targetVec.method_1019(originalVec.method_18806(multipliers).method_1020(originalVec)).method_1019(modifiers);
    }

    private static class_243 calcDynamicOffsets(class_4184 camera, class_1297 cameraEntity, class_1922 level, class_243 targetOffset) {
        class_243 lookVector = new class_243(camera.method_19335());
        class_243 worldXYOffset = new class_243(camera.method_19336()).method_1021(targetOffset.method_10214()).method_1019(new class_243(camera.method_35689()).method_1021(targetOffset.method_10216()));
        class_243 worldOffset = worldXYOffset.method_1019(lookVector.method_1021(-targetOffset.method_10215()));
        double offsetXAbs = Math.abs(targetOffset.method_10216());
        double offsetYAbs = Math.abs(targetOffset.method_10214());
        double offsetZAbs = Math.abs(targetOffset.method_10215());
        double targetX = offsetXAbs;
        double targetY = offsetYAbs;
        double clearance = (double)cameraEntity.method_17681() / 3.0;
        class_243 cameraPosition = camera.method_19326();
        for (double dz = 0.0; dz <= offsetZAbs; dz += 0.03125) {
            double newTargetY;
            class_243 endPos;
            double scale = dz / offsetZAbs;
            class_243 startPos = cameraPosition.method_1019(worldOffset.method_1021(scale));
            class_3959 context = new class_3959(startPos, endPos = cameraPosition.method_1019(worldXYOffset).method_1019(lookVector.method_1021(-dz)), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, cameraEntity);
            class_3965 hitResult = level.method_17742(context);
            if (hitResult.method_17783() == class_239.class_240.field_1333) continue;
            double distance = hitResult.method_17784().method_1022(startPos);
            double newTargetX = Math.max(distance + offsetXAbs * scale - clearance, 0.0);
            if (newTargetX < targetX) {
                targetX = newTargetX;
            }
            if (!((newTargetY = Math.max(distance + offsetYAbs * scale - clearance, 0.0)) < targetY)) continue;
            targetY = newTargetY;
        }
        double targetXOffset = Math.signum(targetOffset.method_10216()) * targetX;
        double targetYOffset = Math.signum(targetOffset.method_10214()) * targetY;
        return new class_243(targetXOffset, targetYOffset, targetOffset.method_10215());
    }

    private static double maxZoom(class_4184 camera, class_1922 level, class_243 cameraOffset, float partialTick) {
        double distance = cameraOffset.method_1033();
        class_243 worldOffset = new class_243(camera.method_19336()).method_1021(cameraOffset.method_10214()).method_1019(new class_243(camera.method_35689()).method_1021(cameraOffset.method_10216())).method_1019(new class_243(camera.method_19335()).method_1021(-cameraOffset.method_10215()));
        class_243 eyePosition = camera.method_19331().method_5836(partialTick);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            class_243 to;
            class_243 offset = new class_243((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).method_1021(2.0).method_1023(1.0, 1.0, 1.0).method_1021(0.15).method_1024(-camera.method_19330() * ((float)Math.PI / 180));
            class_243 from = eyePosition.method_1019(offset);
            class_3959 context = new class_3959(from, to = from.method_1019(worldOffset), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, camera.method_19331());
            class_3965 hitResult = level.method_17742(context);
            if (hitResult.method_17783() == class_239.class_240.field_1333 || !((newDistance = hitResult.method_17784().method_1022(eyePosition)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    public boolean turn(class_746 player, double yRot, double xRot) {
        if (this.instance.isShoulderSurfing()) {
            float scaledXRot = (float)(xRot * (double)0.15f);
            float scaledYRot = (float)(yRot * (double)0.15f);
            if (this.instance.isFreeLooking()) {
                this.xRotOffset = class_3532.method_15363((float)(this.xRotOffset + scaledXRot), (float)-90.0f, (float)90.0f);
                this.yRotOffset = class_3532.method_15393((float)(this.yRotOffset + scaledYRot));
                this.xRotOffsetO = this.xRotOffset;
                this.yRotOffsetO = this.yRotOffset;
                return true;
            }
            float cameraXRot = class_3532.method_15363((float)(this.xRot + scaledXRot), (float)-90.0f, (float)90.0f);
            float cameraYRot = this.yRot + scaledYRot;
            if (player.method_5765()) {
                Vec2f constraintRotations = ShoulderSurfingCamera.applyPassengerRotationConstraints((class_1657)player, cameraXRot, cameraYRot, this.xRot, this.yRot);
                cameraXRot = constraintRotations.x();
                cameraYRot = constraintRotations.y();
            }
            if (Config.CLIENT.isCameraDecoupled()) {
                boolean isMoving;
                boolean bl = isMoving = player.field_3913.field_3907 != 0.0f || player.field_3913.field_3905 != 0.0f || player.method_6128();
                if (this.instance.shouldEntityFollowCamera((class_1309)player)) {
                    player.method_36457(cameraXRot);
                    player.method_36456(cameraYRot);
                    player.field_6004 += class_3532.method_15381((float)this.xRot, (float)cameraXRot);
                    player.field_5982 += class_3532.method_15381((float)this.yRot, (float)cameraYRot);
                } else if (!this.instance.shouldEntityAimAtTarget((class_1309)player, class_310.method_1551())) {
                    if (Config.CLIENT.shouldPlayerXRotFollowCamera()) {
                        player.method_36457(cameraXRot);
                        player.field_6004 += class_3532.method_15381((float)this.xRot, (float)cameraXRot);
                    }
                    if (Config.CLIENT.shouldPlayerYRotFollowCamera() && !isMoving) {
                        float maxFollowAngle = (float)Config.CLIENT.getPlayerYRotFollowAngleLimit();
                        float playerYRot = class_3532.method_15388((float)this.lastMovedYRot, (float)(player.method_36454() + scaledYRot), (float)maxFollowAngle);
                        player.field_5982 = player.method_36454();
                        player.method_36456(playerYRot);
                    }
                }
                if (isMoving) {
                    this.lastMovedYRot = player.method_36454();
                }
            }
            this.xRot = cameraXRot;
            this.yRot = cameraYRot;
            return Config.CLIENT.isCameraDecoupled();
        }
        return false;
    }

    private static Vec2f applyPassengerRotationConstraints(class_1657 player, float cameraXRot, float cameraYRot, float cameraXRotO, float cameraYRotO) {
        class_1297 vehicle = player.method_5854();
        float partialTick = class_310.method_1551().method_1488();
        float playerXRot = player.method_36455();
        float playerYRot = player.method_36454();
        float playerXRotO = player.field_6004;
        float playerYRotO = player.field_5982;
        float playerYHeadRot = player.field_6241;
        float playerYHeadRotO = player.field_6259;
        float playerYBodyRot = player.field_6283;
        float playerYBodyRotO = player.field_6220;
        float vehicleXRot = vehicle.method_36455();
        float vehicleYRot = vehicle.method_36454();
        float vehicleXRotO = vehicle.field_6004;
        float vehicleYRotO = vehicle.field_5982;
        vehicle.method_36457(class_3532.method_17821((float)partialTick, (float)vehicleXRotO, (float)vehicleXRot));
        vehicle.method_36456(class_3532.method_17821((float)partialTick, (float)vehicleYRotO, (float)vehicleYRot));
        player.method_36457(cameraXRot);
        player.method_36456(cameraYRot);
        player.field_6004 = cameraXRotO;
        player.field_5982 = cameraYRotO;
        player.field_6241 = cameraYRot;
        player.field_6259 = cameraYRotO;
        player.field_6283 = cameraYRot;
        player.field_6220 = cameraYRotO;
        vehicle.method_5644((class_1297)player);
        if (player.method_36455() != cameraXRot) {
            cameraXRot = player.method_36455();
        }
        if (player.method_36454() != cameraYRot) {
            cameraYRot = player.method_36454();
        }
        player.method_36457(playerXRot);
        player.method_36456(playerYRot);
        player.field_6004 = playerXRotO;
        player.field_5982 = playerYRotO;
        player.field_6241 = playerYHeadRot;
        player.field_6259 = playerYHeadRotO;
        player.field_6283 = playerYBodyRot;
        player.field_6220 = playerYBodyRotO;
        vehicle.method_36457(vehicleXRot);
        vehicle.method_36456(vehicleYRot);
        return new Vec2f(cameraXRot, cameraYRot);
    }

    public void resetState() {
        this.initialized = false;
    }

    @Override
    public double getCameraDistance() {
        return this.cameraDistance;
    }

    @Override
    public class_243 getOffset() {
        return this.offset;
    }

    @Override
    public class_243 getRenderOffset() {
        return this.renderOffset;
    }

    @Override
    public class_243 getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public float getXRot() {
        return this.xRot + this.xRotOffset;
    }

    @Override
    public void setXRot(float xRot) {
        this.xRot = xRot;
        this.xRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
    }

    @Override
    public float getYRot() {
        return this.yRot + this.yRotOffset;
    }

    @Override
    public void setYRot(float yRot) {
        this.yRot = yRot;
        this.yRotOffset = 0.0f;
        this.yRotOffsetO = 0.0f;
    }

    public float getFreeLookYRot() {
        return this.freeLookYRot;
    }

    public void setLastMovedYRot(float lastMovedYRot) {
        this.lastMovedYRot = lastMovedYRot;
    }
}

