/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.fabric.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderIrisCompatMixinPlugin
implements IMixinConfigPlugin {
    private final Map<String, Supplier<Predicate<Version>>> rules = new HashMap<String, Supplier<Predicate<Version>>>();

    public void onLoad(String mixinPackage) {
        this.rules.put(mixinPackage + ".MixinSheets", () -> ShoulderIrisCompatMixinPlugin.parseVersionPredicateSilent(">=1.7.0-snapshot"));
        this.rules.put(mixinPackage + ".MixinSheetsLegacy", () -> ShoulderIrisCompatMixinPlugin.parseVersionPredicateSilent("<1.7.0-snapshot >=1.6.17"));
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String irisVersion;
        if (this.rules.containsKey(mixinClassName) && (irisVersion = Mods.IRIS.getModVersion()) != null) {
            Predicate<Version> versionPredicate = this.rules.get(mixinClassName).get();
            return versionPredicate.test(ShoulderIrisCompatMixinPlugin.parseVersionSilent(irisVersion));
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static Version parseVersionSilent(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static VersionPredicate parseVersionPredicateSilent(String predicate) {
        try {
            return VersionPredicate.parse((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

