/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.ShoulderSurfingCommon;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.plugin.CreateModTargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5272;
import net.minecraft.class_7923;

public class ShoulderSurfingPlugin
implements IShoulderSurfingPlugin {
    @Override
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerAdaptiveItemCallback(ShoulderSurfingPlugin::isHoldingAdaptiveItem);
        if (Mods.CREATE.isLoaded()) {
            try {
                ShoulderSurfingCommon.LOGGER.info("Registering compatibility callback for create mod");
                registrar.registerTargetCameraOffsetCallback(new CreateModTargetCameraOffsetCallback());
            }
            catch (Throwable t) {
                ShoulderSurfingCommon.LOGGER.error("Failed to load compatibility callback for create mod", t);
            }
        }
    }

    private static boolean isHoldingAdaptiveItem(class_310 minecraft, class_1309 entity) {
        class_1792 useItem = entity.method_6030().method_7909();
        List<? extends String> useItems = Config.CLIENT.getAdaptiveCrosshairUseItems();
        List<? extends String> useItemProperties = Config.CLIENT.getAdaptiveCrosshairUseItemProperties();
        String useItemId = class_7923.field_41178.method_10221((Object)useItem).toString();
        if (useItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(useItemId))) {
            return true;
        }
        for (String string : useItemProperties) {
            if (class_5272.method_27878((class_1792)useItem, (class_2960)new class_2960(string)) == null) continue;
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> list = Config.CLIENT.getAdaptiveCrosshairHoldItemProperties();
        for (class_1799 handStack : entity.method_5877()) {
            class_1792 handItem = handStack.method_7909();
            String handItemId = class_7923.field_41178.method_10221((Object)handItem).toString();
            if (holdItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(handItemId))) {
                return true;
            }
            for (String string : list) {
                if (class_5272.method_27878((class_1792)handItem, (class_2960)new class_2960(string)) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

